/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache.item;

import net.runelite.cache.item.Graphics3D;
import net.runelite.cache.item.Renderable;

class Model
extends Renderable {
    boolean[] faceClipped = new boolean[6500];
    int[] modelViewportYs = new int[6500];
    int[] modelViewportXs = new int[6500];
    int[] modelViewportZs = new int[6500];
    int[] modelLocalX = new int[6500];
    int[] modelLocalY = new int[6500];
    int[] modelLocalZ = new int[6500];
    int[] distanceFaceCount = new int[6000];
    int[][] facesByDistance = new int[6000][512];
    int[] numOfPriority = new int[12];
    int[][] orderedFaces = new int[12][2000];
    int[] eq10 = new int[2000];
    int[] eq11 = new int[2000];
    int[] lt10 = new int[12];
    static int[] Model_sine = Graphics3D.SINE;
    static int[] Model_cosine = Graphics3D.COSINE;
    int verticesCount = 0;
    int[] verticesX;
    int[] verticesY;
    int[] verticesZ;
    int indicesCount = 0;
    int[] indices1;
    int[] indices2;
    int[] indices3;
    int[] faceColors1;
    int[] faceColors2;
    int[] faceColors3;
    byte[] facePriorities;
    byte[] faceTransparencies;
    byte[] textureCoords;
    short[] faceTextures;
    int numTextureFaces = 0;
    int[] texIndices1;
    int[] texIndices2;
    int[] texIndices3;
    int boundsType;
    int bottomY;
    int XYZMag;
    int diameter;
    int radius;
    public int extremeX = -1;
    public int extremeY = -1;
    public int extremeZ = -1;

    Model() {
    }

    public void calculateBoundsCylinder() {
        if (this.boundsType != 1) {
            this.boundsType = 1;
            this.modelHeight = 0;
            this.bottomY = 0;
            this.XYZMag = 0;
            for (int var1 = 0; var1 < this.verticesCount; ++var1) {
                int var5;
                int var2 = this.verticesX[var1];
                int var3 = this.verticesY[var1];
                int var4 = this.verticesZ[var1];
                if (-var3 > this.modelHeight) {
                    this.modelHeight = -var3;
                }
                if (var3 > this.bottomY) {
                    this.bottomY = var3;
                }
                if ((var5 = var2 * var2 + var4 * var4) <= this.XYZMag) continue;
                this.XYZMag = var5;
            }
            this.XYZMag = (int)(Math.sqrt(this.XYZMag) + 0.99);
            this.radius = (int)(Math.sqrt(this.XYZMag * this.XYZMag + this.modelHeight * this.modelHeight) + 0.99);
            this.diameter = this.radius + (int)(Math.sqrt(this.XYZMag * this.XYZMag + this.bottomY * this.bottomY) + 0.99);
        }
    }

    public final void projectAndDraw(Graphics3D graphics, int yzRotation, int xzRotation, int xyRotation, int orientation, int xOffset, int yOffset, int zOffset) {
        this.distanceFaceCount[0] = -1;
        if (this.boundsType != 2 && this.boundsType != 1) {
            this.boundsType = 2;
            this.XYZMag = 0;
            for (int var1 = 0; var1 < this.verticesCount; ++var1) {
                int x = this.verticesX[var1];
                int z = this.verticesZ[var1];
                int y = this.verticesY[var1];
                int magnitude_squared = x * x + z * z + y * y;
                if (magnitude_squared <= this.XYZMag) continue;
                this.XYZMag = magnitude_squared;
            }
            this.radius = this.XYZMag = (int)(Math.sqrt(this.XYZMag) + 0.99);
            this.diameter = this.XYZMag + this.XYZMag;
        }
        int sinX = Model_sine[orientation];
        int cosX = Model_cosine[orientation];
        int zRelatedVariable = sinX * yOffset + cosX * zOffset >> 16;
        for (int i = 0; i < this.verticesCount; ++i) {
            int tmp;
            int x = this.verticesX[i];
            int y = this.verticesY[i];
            int z = this.verticesZ[i];
            if (xyRotation != 0) {
                int sinZ = Model_sine[xyRotation];
                int cosZ = Model_cosine[xyRotation];
                tmp = y * sinZ + x * cosZ >> 16;
                y = y * cosZ - x * sinZ >> 16;
                x = tmp;
            }
            if (yzRotation != 0) {
                int sinR1 = Model_sine[yzRotation];
                int cosR1 = Model_cosine[yzRotation];
                tmp = y * cosR1 - z * sinR1 >> 16;
                z = y * sinR1 + z * cosR1 >> 16;
                y = tmp;
            }
            if (xzRotation != 0) {
                int sinY = Model_sine[xzRotation];
                int cosY = Model_cosine[xzRotation];
                tmp = z * sinY + x * cosY >> 16;
                z = z * cosY - x * sinY >> 16;
                x = tmp;
            }
            int tmp2 = (y += yOffset) * cosX - (z += zOffset) * sinX >> 16;
            z = y * sinX + z * cosX >> 16;
            this.modelViewportZs[i] = z - zRelatedVariable;
            this.modelViewportYs[i] = (x += xOffset) * graphics.Rasterizer3D_zoom / z + graphics.centerX;
            this.modelViewportXs[i] = tmp2 * graphics.Rasterizer3D_zoom / z + graphics.centerY;
            if (this.faceTextures == null) continue;
            this.modelLocalX[i] = x;
            this.modelLocalY[i] = tmp2;
            this.modelLocalZ[i] = z;
        }
        this.draw(graphics);
    }

    private void draw(Graphics3D graphics) {
        block29: {
            int var9;
            int var27;
            int var11;
            int var7;
            int var10;
            int var26;
            if (this.diameter >= 6000) break block29;
            for (int var5 = 0; var5 < this.diameter; ++var5) {
                this.distanceFaceCount[var5] = 0;
            }
            for (var26 = 0; var26 < this.indicesCount; ++var26) {
                int var13;
                int var12;
                if (this.faceColors3[var26] == -2 || ((var10 = this.modelViewportYs[var7 = this.indices1[var26]]) - (var11 = this.modelViewportYs[var27 = this.indices2[var26]])) * (this.modelViewportXs[var9 = this.indices3[var26]] - this.modelViewportXs[var27]) - ((var12 = this.modelViewportYs[var9]) - var11) * (this.modelViewportXs[var7] - this.modelViewportXs[var27]) <= 0) continue;
                this.faceClipped[var26] = var10 < 0 || var11 < 0 || var12 < 0 || var10 > graphics.rasterClipX || var11 > graphics.rasterClipX || var12 > graphics.rasterClipX;
                int n = var13 = (this.modelViewportZs[var7] + this.modelViewportZs[var27] + this.modelViewportZs[var9]) / 3 + this.radius;
                int n2 = this.distanceFaceCount[n];
                this.distanceFaceCount[n] = n2 + 1;
                this.facesByDistance[var13][n2] = var26;
            }
            if (this.facePriorities == null) {
                for (var26 = this.diameter - 1; var26 >= 0; --var26) {
                    var7 = this.distanceFaceCount[var26];
                    if (var7 <= 0) continue;
                    int[] var8 = this.facesByDistance[var26];
                    for (var9 = 0; var9 < var7; ++var9) {
                        this.rasterFace(graphics, var8[var9]);
                    }
                }
            } else {
                for (var26 = 0; var26 < 12; ++var26) {
                    this.numOfPriority[var26] = 0;
                    this.lt10[var26] = 0;
                }
                for (var26 = this.diameter - 1; var26 >= 0; --var26) {
                    var7 = this.distanceFaceCount[var26];
                    if (var7 <= 0) continue;
                    int[] var8 = this.facesByDistance[var26];
                    for (var9 = 0; var9 < var7; ++var9) {
                        byte var31;
                        var10 = var8[var9];
                        byte by = var31 = this.facePriorities[var10];
                        this.numOfPriority[by] = this.numOfPriority[by] + 1;
                        this.orderedFaces[var31][var12] = var10;
                        if (var31 < 10) {
                            byte by2 = var31;
                            this.lt10[by2] = this.lt10[by2] + var26;
                            continue;
                        }
                        if (var31 == 10) {
                            this.eq10[var12] = var26;
                            continue;
                        }
                        this.eq11[var12] = var26;
                    }
                }
                var26 = 0;
                if (this.numOfPriority[1] > 0 || this.numOfPriority[2] > 0) {
                    var26 = (this.lt10[1] + this.lt10[2]) / (this.numOfPriority[1] + this.numOfPriority[2]);
                }
                var7 = 0;
                if (this.numOfPriority[3] > 0 || this.numOfPriority[4] > 0) {
                    var7 = (this.lt10[3] + this.lt10[4]) / (this.numOfPriority[3] + this.numOfPriority[4]);
                }
                var27 = 0;
                if (this.numOfPriority[6] > 0 || this.numOfPriority[8] > 0) {
                    var27 = (this.lt10[8] + this.lt10[6]) / (this.numOfPriority[8] + this.numOfPriority[6]);
                }
                var10 = 0;
                var11 = this.numOfPriority[10];
                int[] var28 = this.orderedFaces[10];
                int[] var29 = this.eq10;
                if (var10 == var11) {
                    var10 = 0;
                    var11 = this.numOfPriority[11];
                    var28 = this.orderedFaces[11];
                    var29 = this.eq11;
                }
                var9 = var10 < var11 ? var29[var10] : -1000;
                for (int var14 = 0; var14 < 10; ++var14) {
                    while (var14 == 0 && var9 > var26) {
                        this.rasterFace(graphics, var28[var10++]);
                        if (var10 == var11 && var28 != this.orderedFaces[11]) {
                            var10 = 0;
                            var11 = this.numOfPriority[11];
                            var28 = this.orderedFaces[11];
                            var29 = this.eq11;
                        }
                        if (var10 < var11) {
                            var9 = var29[var10];
                            continue;
                        }
                        var9 = -1000;
                    }
                    while (var14 == 3 && var9 > var7) {
                        this.rasterFace(graphics, var28[var10++]);
                        if (var10 == var11 && var28 != this.orderedFaces[11]) {
                            var10 = 0;
                            var11 = this.numOfPriority[11];
                            var28 = this.orderedFaces[11];
                            var29 = this.eq11;
                        }
                        if (var10 < var11) {
                            var9 = var29[var10];
                            continue;
                        }
                        var9 = -1000;
                    }
                    while (var14 == 5 && var9 > var27) {
                        this.rasterFace(graphics, var28[var10++]);
                        if (var10 == var11 && var28 != this.orderedFaces[11]) {
                            var10 = 0;
                            var11 = this.numOfPriority[11];
                            var28 = this.orderedFaces[11];
                            var29 = this.eq11;
                        }
                        if (var10 < var11) {
                            var9 = var29[var10];
                            continue;
                        }
                        var9 = -1000;
                    }
                    int var15 = this.numOfPriority[var14];
                    int[] var30 = this.orderedFaces[var14];
                    for (int var17 = 0; var17 < var15; ++var17) {
                        this.rasterFace(graphics, var30[var17]);
                    }
                }
                while (var9 != -1000) {
                    this.rasterFace(graphics, var28[var10++]);
                    if (var10 == var11 && var28 != this.orderedFaces[11]) {
                        var10 = 0;
                        var28 = this.orderedFaces[11];
                        var11 = this.numOfPriority[11];
                        var29 = this.eq11;
                    }
                    if (var10 < var11) {
                        var9 = var29[var10];
                        continue;
                    }
                    var9 = -1000;
                }
            }
        }
    }

    private void rasterFace(Graphics3D graphics, int face) {
        int var2 = this.indices1[face];
        int var3 = this.indices2[face];
        int var4 = this.indices3[face];
        graphics.rasterClipEnable = this.faceClipped[face];
        graphics.rasterAlpha = this.faceTransparencies == null ? 0 : this.faceTransparencies[face] & 0xFF;
        if (this.faceTextures != null && this.faceTextures[face] != -1) {
            int var7;
            int var6;
            int var5;
            if (this.textureCoords != null && this.textureCoords[face] != -1) {
                int var8 = this.textureCoords[face] & 0xFF;
                var5 = this.texIndices1[var8];
                var6 = this.texIndices2[var8];
                var7 = this.texIndices3[var8];
            } else {
                var5 = var2;
                var6 = var3;
                var7 = var4;
            }
            if (this.faceColors3[face] == -1) {
                graphics.rasterTextureAffine(this.modelViewportXs[var2], this.modelViewportXs[var3], this.modelViewportXs[var4], this.modelViewportYs[var2], this.modelViewportYs[var3], this.modelViewportYs[var4], this.faceColors1[face], this.faceColors1[face], this.faceColors1[face], this.modelLocalX[var5], this.modelLocalX[var6], this.modelLocalX[var7], this.modelLocalY[var5], this.modelLocalY[var6], this.modelLocalY[var7], this.modelLocalZ[var5], this.modelLocalZ[var6], this.modelLocalZ[var7], this.faceTextures[face]);
            } else {
                graphics.rasterTextureAffine(this.modelViewportXs[var2], this.modelViewportXs[var3], this.modelViewportXs[var4], this.modelViewportYs[var2], this.modelViewportYs[var3], this.modelViewportYs[var4], this.faceColors1[face], this.faceColors2[face], this.faceColors3[face], this.modelLocalX[var5], this.modelLocalX[var6], this.modelLocalX[var7], this.modelLocalY[var5], this.modelLocalY[var6], this.modelLocalY[var7], this.modelLocalZ[var5], this.modelLocalZ[var6], this.modelLocalZ[var7], this.faceTextures[face]);
            }
        } else if (this.faceColors3[face] == -1) {
            int[] field1889 = graphics.colorPalette;
            graphics.rasterFlat(this.modelViewportXs[var2], this.modelViewportXs[var3], this.modelViewportXs[var4], this.modelViewportYs[var2], this.modelViewportYs[var3], this.modelViewportYs[var4], field1889[this.faceColors1[face]]);
        } else {
            graphics.rasterGouraud(this.modelViewportXs[var2], this.modelViewportXs[var3], this.modelViewportXs[var4], this.modelViewportYs[var2], this.modelViewportYs[var3], this.modelViewportYs[var4], this.faceColors1[face], this.faceColors2[face], this.faceColors3[face]);
        }
    }
}

