/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache.io;

import java.io.IOException;
import java.nio.ByteBuffer;

public class InputStream
extends java.io.InputStream {
    private static final char[] CHARACTERS = new char[]{'\u20ac', '\u0000', '\u201a', '\u0192', '\u201e', '\u2026', '\u2020', '\u2021', '\u02c6', '\u2030', '\u0160', '\u2039', '\u0152', '\u0000', '\u017d', '\u0000', '\u0000', '\u2018', '\u2019', '\u201c', '\u201d', '\u2022', '\u2013', '\u2014', '\u02dc', '\u2122', '\u0161', '\u203a', '\u0153', '\u0000', '\u017e', '\u0178'};
    private final ByteBuffer buffer;

    public InputStream(byte[] buffer) {
        this.buffer = ByteBuffer.wrap(buffer);
    }

    public byte[] getArray() {
        assert (this.buffer.hasArray());
        return this.buffer.array();
    }

    public String toString() {
        return "InputStream{buffer=" + String.valueOf(this.buffer) + "}";
    }

    public int read24BitInt() {
        return (this.readUnsignedByte() << 16) + (this.readUnsignedByte() << 8) + this.readUnsignedByte();
    }

    public void skip(int length) {
        int pos = this.buffer.position();
        this.buffer.position(pos += length);
    }

    public void setOffset(int offset) {
        this.buffer.position(offset);
    }

    public int getOffset() {
        return this.buffer.position();
    }

    public int getLength() {
        return this.buffer.limit();
    }

    public int remaining() {
        return this.buffer.remaining();
    }

    public byte readByte() {
        return this.buffer.get();
    }

    public void readBytes(byte[] buffer, int off, int len) {
        this.buffer.get(buffer, off, len);
    }

    public void readBytes(byte[] buffer) {
        this.buffer.get(buffer);
    }

    public int readUnsignedByte() {
        return this.readByte() & 0xFF;
    }

    public int readUnsignedShort() {
        return this.buffer.getShort() & 0xFFFF;
    }

    public short readShort() {
        return this.buffer.getShort();
    }

    public int readInt() {
        return this.buffer.getInt();
    }

    public long readLong() {
        return this.buffer.getLong();
    }

    public byte peek() {
        return this.buffer.get(this.buffer.position());
    }

    public int readBigSmart() {
        return this.peek() >= 0 ? this.readUnsignedShort() & 0xFFFF : this.readInt() & Integer.MAX_VALUE;
    }

    public int readBigSmart2() {
        if (this.peek() < 0) {
            return this.readInt() & Integer.MAX_VALUE;
        }
        int value = this.readUnsignedShort();
        return value == Short.MAX_VALUE ? -1 : value;
    }

    public int readShortSmart() {
        int peek = this.peek() & 0xFF;
        return peek < 128 ? this.readUnsignedByte() - 64 : this.readUnsignedShort() - 49152;
    }

    public int readUnsignedShortSmartMinusOne() {
        int peek = this.peek() & 0xFF;
        return peek < 128 ? this.readUnsignedByte() - 1 : this.readUnsignedShort() - 32769;
    }

    public int readUnsignedShortSmart() {
        int peek = this.peek() & 0xFF;
        return peek < 128 ? this.readUnsignedByte() : this.readUnsignedShort() - 32768;
    }

    public int readUnsignedIntSmartShortCompat() {
        int var1 = 0;
        int var2 = this.readUnsignedShortSmart();
        while (var2 == Short.MAX_VALUE) {
            var1 += Short.MAX_VALUE;
            var2 = this.readUnsignedShortSmart();
        }
        return var1 += var2;
    }

    public String readString() {
        int ch;
        StringBuilder sb = new StringBuilder();
        while ((ch = this.readUnsignedByte()) != 0) {
            if (ch >= 128 && ch < 160) {
                int var7 = CHARACTERS[ch - 128];
                if (0 == var7) {
                    var7 = 63;
                }
                ch = var7;
            }
            sb.append((char)ch);
        }
        return sb.toString();
    }

    public String readString2() {
        if (this.readByte() != 0) {
            throw new IllegalStateException("Invalid jstr2");
        }
        return this.readString();
    }

    public String readStringOrNull() {
        if (this.peek() != 0) {
            return this.readString();
        }
        this.readByte();
        return null;
    }

    public int readVarInt() {
        byte var1 = this.readByte();
        int var2 = 0;
        while (var1 < 0) {
            var2 = (var2 | var1 & 0x7F) << 7;
            var1 = this.readByte();
        }
        return var2 | var1;
    }

    public int readVarInt2() {
        int read;
        int value = 0;
        int bits = 0;
        do {
            read = this.readUnsignedByte();
            value |= (read & 0x7F) << bits;
            bits += 7;
        } while (read > 127);
        return value;
    }

    public byte[] getRemaining() {
        byte[] b = new byte[this.buffer.remaining()];
        this.buffer.get(b);
        return b;
    }

    @Override
    public int read() throws IOException {
        return this.readUnsignedByte();
    }
}

