/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache.index;

import net.runelite.cache.index.ArchiveData;
import net.runelite.cache.index.FileData;
import net.runelite.cache.io.InputStream;
import net.runelite.cache.io.OutputStream;

public class IndexData {
    private static final int NAMED = 1;
    private static final int SIZED = 4;
    private int protocol;
    private int revision;
    private boolean named;
    private boolean sized;
    private ArchiveData[] archives;

    public void load(byte[] data) {
        int num;
        int index;
        ArchiveData ad;
        int index2;
        int flags;
        InputStream stream = new InputStream(data);
        this.protocol = stream.readUnsignedByte();
        if (this.protocol < 5 || this.protocol > 7) {
            throw new IllegalArgumentException("Unsupported protocol");
        }
        if (this.protocol >= 6) {
            this.revision = stream.readInt();
        }
        this.named = ((flags = stream.readUnsignedByte()) & 1) != 0;
        boolean bl = this.sized = (flags & 4) != 0;
        if ((flags & 0xFFFFFFFA) != 0) {
            throw new IllegalArgumentException("Unknown flags: " + flags);
        }
        int validArchivesCount = this.protocol >= 7 ? stream.readBigSmart() : stream.readUnsignedShort();
        int lastArchiveId = 0;
        this.archives = new ArchiveData[validArchivesCount];
        for (index2 = 0; index2 < validArchivesCount; ++index2) {
            int archive = lastArchiveId += this.protocol >= 7 ? stream.readBigSmart() : stream.readUnsignedShort();
            ad = new ArchiveData();
            ad.id = archive;
            this.archives[index2] = ad;
        }
        if (this.named) {
            for (index2 = 0; index2 < validArchivesCount; ++index2) {
                int nameHash = stream.readInt();
                ad = this.archives[index2];
                ad.nameHash = nameHash;
            }
        }
        for (index2 = 0; index2 < validArchivesCount; ++index2) {
            int crc = stream.readInt();
            ad = this.archives[index2];
            ad.crc = crc;
        }
        if (this.sized) {
            for (int i = 0; i < validArchivesCount; ++i) {
                ArchiveData ad2 = this.archives[i];
                ad2.compressedSize = stream.readInt();
                ad2.decompressedSize = stream.readInt();
            }
        }
        for (index2 = 0; index2 < validArchivesCount; ++index2) {
            int revision = stream.readInt();
            ad = this.archives[index2];
            ad.revision = revision;
        }
        int[] numberOfFiles = new int[validArchivesCount];
        for (index = 0; index < validArchivesCount; ++index) {
            int num2;
            numberOfFiles[index] = num2 = this.protocol >= 7 ? stream.readBigSmart() : stream.readUnsignedShort();
        }
        for (index = 0; index < validArchivesCount; ++index) {
            ArchiveData ad3 = this.archives[index];
            num = numberOfFiles[index];
            ad3.files = new FileData[num];
            int last = 0;
            for (int i = 0; i < num; ++i) {
                int fileId = last += this.protocol >= 7 ? stream.readBigSmart() : stream.readUnsignedShort();
                FileData fd = ad3.files[i] = new FileData();
                fd.id = fileId;
            }
        }
        if (this.named) {
            for (index = 0; index < validArchivesCount; ++index) {
                ArchiveData ad4 = this.archives[index];
                num = numberOfFiles[index];
                for (int i = 0; i < num; ++i) {
                    int name;
                    FileData fd = ad4.files[i];
                    fd.nameHash = name = stream.readInt();
                }
            }
        }
    }

    public byte[] writeIndexData() {
        FileData file;
        int j;
        ArchiveData a;
        int i;
        OutputStream stream = new OutputStream();
        stream.writeByte(this.protocol);
        if (this.protocol >= 6) {
            stream.writeInt(this.revision);
        }
        stream.writeByte((this.named ? 1 : 0) | (this.sized ? 4 : 0));
        if (this.protocol >= 7) {
            stream.writeBigSmart(this.archives.length);
        } else {
            stream.writeShort(this.archives.length);
        }
        for (i = 0; i < this.archives.length; ++i) {
            a = this.archives[i];
            int archive = a.getId();
            if (i != 0) {
                ArchiveData prev = this.archives[i - 1];
                assert (a.id > prev.id) : "archive ids out of order";
                archive -= prev.getId();
            }
            if (this.protocol >= 7) {
                stream.writeBigSmart(archive);
                continue;
            }
            stream.writeShort(archive);
        }
        if (this.named) {
            for (i = 0; i < this.archives.length; ++i) {
                a = this.archives[i];
                stream.writeInt(a.getNameHash());
            }
        }
        for (i = 0; i < this.archives.length; ++i) {
            a = this.archives[i];
            stream.writeInt(a.getCrc());
        }
        if (this.sized) {
            for (i = 0; i < this.archives.length; ++i) {
                a = this.archives[i];
                stream.writeInt(a.getCompressedSize());
                stream.writeInt(a.getDecompressedSize());
            }
        }
        for (i = 0; i < this.archives.length; ++i) {
            a = this.archives[i];
            stream.writeInt(a.getRevision());
        }
        for (i = 0; i < this.archives.length; ++i) {
            a = this.archives[i];
            int len = a.getFiles().length;
            if (this.protocol >= 7) {
                stream.writeBigSmart(len);
                continue;
            }
            stream.writeShort(len);
        }
        for (i = 0; i < this.archives.length; ++i) {
            a = this.archives[i];
            for (j = 0; j < a.getFiles().length; ++j) {
                file = a.getFiles()[j];
                int offset = file.getId();
                if (j != 0) {
                    FileData prev = a.getFiles()[j - 1];
                    assert (file.id > prev.id) : "file ids out of order";
                    offset -= prev.getId();
                }
                if (this.protocol >= 7) {
                    stream.writeBigSmart(offset);
                    continue;
                }
                stream.writeShort(offset);
            }
        }
        if (this.named) {
            for (i = 0; i < this.archives.length; ++i) {
                a = this.archives[i];
                for (j = 0; j < a.getFiles().length; ++j) {
                    file = a.getFiles()[j];
                    stream.writeInt(file.getNameHash());
                }
            }
        }
        return stream.flip();
    }

    public void setProtocol(int protocol) {
        this.protocol = protocol;
    }

    public void setRevision(int revision) {
        this.revision = revision;
    }

    public void setNamed(boolean named) {
        this.named = named;
    }

    public void setSized(boolean sized) {
        this.sized = sized;
    }

    public void setArchives(ArchiveData[] archives) {
        this.archives = archives;
    }

    public int getProtocol() {
        return this.protocol;
    }

    public int getRevision() {
        return this.revision;
    }

    public boolean isNamed() {
        return this.named;
    }

    public boolean isSized() {
        return this.sized;
    }

    public ArchiveData[] getArchives() {
        return this.archives;
    }
}

