/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache.fs.jagex;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import net.runelite.cache.fs.jagex.IndexEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexFile
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(IndexFile.class);
    private static final int INDEX_ENTRY_LEN = 6;
    private final int indexFileId;
    private final File file;
    private final RandomAccessFile idx;
    private final byte[] buffer = new byte[6];

    public IndexFile(int indexFileId, File file) throws FileNotFoundException {
        this.indexFileId = indexFileId;
        this.file = file;
        this.idx = new RandomAccessFile(file, "rw");
    }

    @Override
    public void close() throws IOException {
        this.idx.close();
    }

    public void clear() throws IOException {
        this.idx.setLength(0L);
    }

    public synchronized void write(IndexEntry entry) throws IOException {
        this.idx.seek(entry.getId() * 6);
        this.buffer[0] = (byte)(entry.getLength() >> 16);
        this.buffer[1] = (byte)(entry.getLength() >> 8);
        this.buffer[2] = (byte)entry.getLength();
        this.buffer[3] = (byte)(entry.getSector() >> 16);
        this.buffer[4] = (byte)(entry.getSector() >> 8);
        this.buffer[5] = (byte)entry.getSector();
        this.idx.write(this.buffer);
    }

    public synchronized IndexEntry read(int id) throws IOException {
        this.idx.seek(id * 6);
        int i = this.idx.read(this.buffer);
        if (i != 6) {
            logger.debug("short read for id {} on index {}: {}", new Object[]{id, this.indexFileId, i});
            return null;
        }
        int length = (this.buffer[0] & 0xFF) << 16 | (this.buffer[1] & 0xFF) << 8 | this.buffer[2] & 0xFF;
        int sector = (this.buffer[3] & 0xFF) << 16 | (this.buffer[4] & 0xFF) << 8 | this.buffer[5] & 0xFF;
        if (length <= 0 || sector <= 0) {
            logger.debug("invalid length or sector {}/{}", (Object)length, (Object)sector);
            return null;
        }
        return new IndexEntry(this, id, sector, length);
    }

    public synchronized int getIndexCount() throws IOException {
        return (int)(this.idx.length() / 6L);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IndexFile)) {
            return false;
        }
        IndexFile other = (IndexFile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        File this$file = this.file;
        File other$file = other.file;
        return !(this$file == null ? other$file != null : !((Object)this$file).equals(other$file));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IndexFile;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        File $file = this.file;
        result = result * 59 + ($file == null ? 43 : ((Object)$file).hashCode());
        return result;
    }

    public int getIndexFileId() {
        return this.indexFileId;
    }
}

