/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache.fs;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.runelite.cache.IndexType;
import net.runelite.cache.fs.Index;
import net.runelite.cache.fs.Storage;
import net.runelite.cache.fs.jagex.DiskStorage;

public final class Store
implements Closeable {
    private final Storage storage;
    private final List<Index> indexes = new ArrayList<Index>();

    public Store(File folder) throws IOException {
        this.storage = new DiskStorage(folder);
        this.storage.init(this);
    }

    public Store(Storage storage) throws IOException {
        this.storage = storage;
        storage.init(this);
    }

    public Storage getStorage() {
        return this.storage;
    }

    @Override
    public void close() throws IOException {
        this.storage.close();
    }

    public Index addIndex(int id) {
        for (Index i : this.indexes) {
            if (i.getId() != id) continue;
            throw new IllegalArgumentException("index " + id + " already exists");
        }
        Index index = new Index(id);
        this.indexes.add(index);
        return index;
    }

    public void removeIndex(Index index) {
        assert (this.indexes.contains(index));
        this.indexes.remove(index);
    }

    public void load() throws IOException {
        this.storage.load(this);
    }

    public void save() throws IOException {
        this.storage.save(this);
    }

    public List<Index> getIndexes() {
        return this.indexes;
    }

    public Index getIndex(IndexType type) {
        return this.findIndex(type.getNumber());
    }

    public Index findIndex(int id) {
        for (Index i : this.indexes) {
            if (i.getId() != id) continue;
            return i;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Store)) {
            return false;
        }
        Store other = (Store)o;
        List<Index> this$indexes = this.getIndexes();
        List<Index> other$indexes = other.getIndexes();
        return !(this$indexes == null ? other$indexes != null : !((Object)this$indexes).equals(other$indexes));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Index> $indexes = this.getIndexes();
        result = result * 59 + ($indexes == null ? 43 : ((Object)$indexes).hashCode());
        return result;
    }
}

