/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache.fs;

import java.util.Arrays;

public class FSFile {
    private final int fileId;
    private int nameHash;
    private byte[] contents;

    public FSFile(int fileId) {
        this.fileId = fileId;
    }

    public int getSize() {
        return this.contents.length;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FSFile)) {
            return false;
        }
        FSFile other = (FSFile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getFileId() != other.getFileId()) {
            return false;
        }
        if (this.getNameHash() != other.getNameHash()) {
            return false;
        }
        return Arrays.equals(this.getContents(), other.getContents());
    }

    protected boolean canEqual(Object other) {
        return other instanceof FSFile;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getFileId();
        result = result * 59 + this.getNameHash();
        result = result * 59 + Arrays.hashCode(this.getContents());
        return result;
    }

    public int getFileId() {
        return this.fileId;
    }

    public int getNameHash() {
        return this.nameHash;
    }

    public void setNameHash(int nameHash) {
        this.nameHash = nameHash;
    }

    public byte[] getContents() {
        return this.contents;
    }

    public void setContents(byte[] contents) {
        this.contents = contents;
    }
}

