/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache.fs;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import net.runelite.cache.fs.FSFile;
import net.runelite.cache.io.InputStream;
import net.runelite.cache.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveFiles {
    private static final Logger logger = LoggerFactory.getLogger(ArchiveFiles.class);
    private final LinkedHashMap<Integer, FSFile> files = new LinkedHashMap();

    public void addFile(FSFile file) {
        Preconditions.checkArgument((file.getFileId() != -1 ? 1 : 0) != 0);
        if (this.files.containsKey(file.getFileId())) {
            throw new IllegalStateException("duplicate file ids");
        }
        this.files.put(file.getFileId(), file);
    }

    public Collection<FSFile> getFiles() {
        return Collections.unmodifiableCollection(this.files.values());
    }

    public FSFile findFile(int fileId) {
        return this.files.get(fileId);
    }

    public void clear() {
        this.files.clear();
    }

    public void loadContents(byte[] data) {
        logger.trace("Loading contents of archive ({} files)", (Object)this.files.size());
        assert (!this.getFiles().isEmpty());
        if (this.files.size() == 1) {
            FSFile f = this.files.values().iterator().next();
            f.setContents(data);
            return;
        }
        int filesCount = this.getFiles().size();
        InputStream stream = new InputStream(data);
        stream.setOffset(stream.getLength() - 1);
        int chunks = stream.readUnsignedByte();
        stream.setOffset(stream.getLength() - 1 - chunks * filesCount * 4);
        int[][] chunkSizes = new int[filesCount][chunks];
        int[] filesSize = new int[filesCount];
        for (int chunk = 0; chunk < chunks; ++chunk) {
            int chunkSize = 0;
            int id = 0;
            while (id < filesCount) {
                int delta = stream.readInt();
                chunkSizes[id][chunk] = chunkSize += delta;
                int n = id++;
                filesSize[n] = filesSize[n] + chunkSize;
            }
        }
        byte[][] fileContents = new byte[filesCount][];
        int[] fileOffsets = new int[filesCount];
        for (int i = 0; i < filesCount; ++i) {
            fileContents[i] = new byte[filesSize[i]];
        }
        stream.setOffset(0);
        for (int chunk = 0; chunk < chunks; ++chunk) {
            int id = 0;
            while (id < filesCount) {
                int chunkSize = chunkSizes[id][chunk];
                stream.readBytes(fileContents[id], fileOffsets[id], chunkSize);
                int n = id++;
                fileOffsets[n] = fileOffsets[n] + chunkSize;
            }
        }
        Iterator<FSFile> iter = this.files.values().iterator();
        for (int i = 0; i < filesCount; ++i) {
            FSFile f = iter.next();
            f.setContents(fileContents[i]);
        }
    }

    public byte[] saveContents() {
        OutputStream stream = new OutputStream();
        int filesCount = this.getFiles().size();
        if (filesCount == 1) {
            FSFile file = this.files.values().iterator().next();
            stream.writeBytes(file.getContents());
        } else {
            for (FSFile file : this.getFiles()) {
                byte[] contents = file.getContents();
                stream.writeBytes(contents);
            }
            int offset = 0;
            for (FSFile file : this.getFiles()) {
                int chunkSize = file.getSize();
                int sz = chunkSize - offset;
                offset = chunkSize;
                stream.writeInt(sz);
            }
            stream.writeByte(1);
        }
        byte[] fileData = stream.flip();
        logger.trace("Saved contents of archive ({} files), {} bytes", (Object)this.files.size(), (Object)fileData.length);
        return fileData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArchiveFiles)) {
            return false;
        }
        ArchiveFiles other = (ArchiveFiles)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Collection<FSFile> this$files = this.getFiles();
        Collection<FSFile> other$files = other.getFiles();
        return !(this$files == null ? other$files != null : !((Object)this$files).equals(other$files));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ArchiveFiles;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Collection<FSFile> $files = this.getFiles();
        result = result * 59 + ($files == null ? 43 : ((Object)$files).hashCode());
        return result;
    }
}

