/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache.fs;

import java.io.IOException;
import net.runelite.cache.fs.ArchiveFiles;
import net.runelite.cache.fs.Container;
import net.runelite.cache.fs.FSFile;
import net.runelite.cache.fs.Index;
import net.runelite.cache.index.FileData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Archive {
    private static final Logger logger = LoggerFactory.getLogger(Archive.class);
    private final Index index;
    private final int archiveId;
    private int nameHash;
    private int crc;
    private int compressedSize;
    private int decompressedSize;
    private int revision;
    private int compression;
    private FileData[] fileData;

    public Archive(Index index, int id) {
        this.index = index;
        this.archiveId = id;
    }

    public byte[] decompress(byte[] data) throws IOException {
        return this.decompress(data, null);
    }

    public byte[] decompress(byte[] data, int[] keys) throws IOException {
        if (data == null) {
            return null;
        }
        Container container = Container.decompress(data, keys);
        byte[] decompressedData = container.data;
        if (this.crc != container.crc) {
            logger.warn("crc mismatch for archive {}/{}", (Object)this.index.getId(), (Object)this.getArchiveId());
            throw new IOException("CRC mismatch for " + this.index.getId() + "/" + this.getArchiveId());
        }
        if (container.revision != -1 && this.revision != container.revision) {
            logger.warn("revision mismatch for archive {}/{}, expected {} was {}", new Object[]{this.index.getId(), this.getArchiveId(), this.revision, container.revision});
            this.revision = container.revision;
        }
        this.compression = container.compression;
        return decompressedData;
    }

    public ArchiveFiles getFiles(byte[] data) throws IOException {
        return this.getFiles(data, null);
    }

    public ArchiveFiles getFiles(byte[] data, int[] keys) throws IOException {
        byte[] decompressedData = this.decompress(data, keys);
        ArchiveFiles files = new ArchiveFiles();
        for (FileData fileEntry : this.fileData) {
            FSFile file = new FSFile(fileEntry.getId());
            file.setNameHash(fileEntry.getNameHash());
            files.addFile(file);
        }
        files.loadContents(decompressedData);
        return files;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Archive)) {
            return false;
        }
        Archive other = (Archive)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getArchiveId() != other.getArchiveId()) {
            return false;
        }
        if (this.getNameHash() != other.getNameHash()) {
            return false;
        }
        return this.getRevision() == other.getRevision();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Archive;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getArchiveId();
        result = result * 59 + this.getNameHash();
        result = result * 59 + this.getRevision();
        return result;
    }

    public Index getIndex() {
        return this.index;
    }

    public int getArchiveId() {
        return this.archiveId;
    }

    public int getNameHash() {
        return this.nameHash;
    }

    public void setNameHash(int nameHash) {
        this.nameHash = nameHash;
    }

    public int getCrc() {
        return this.crc;
    }

    public void setCrc(int crc) {
        this.crc = crc;
    }

    public int getCompressedSize() {
        return this.compressedSize;
    }

    public void setCompressedSize(int compressedSize) {
        this.compressedSize = compressedSize;
    }

    public int getDecompressedSize() {
        return this.decompressedSize;
    }

    public void setDecompressedSize(int decompressedSize) {
        this.decompressedSize = decompressedSize;
    }

    public int getRevision() {
        return this.revision;
    }

    public void setRevision(int revision) {
        this.revision = revision;
    }

    public int getCompression() {
        return this.compression;
    }

    public void setCompression(int compression) {
        this.compression = compression;
    }

    public FileData[] getFileData() {
        return this.fileData;
    }

    public void setFileData(FileData[] fileData) {
        this.fileData = fileData;
    }
}

