/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache.definitions.savers;

import java.util.Map;
import net.runelite.cache.definitions.ScriptDefinition;
import net.runelite.cache.io.OutputStream;

public class ScriptSaver {
    public byte[] save(ScriptDefinition script) {
        int[] instructions = script.getInstructions();
        int[] intOperands = script.getIntOperands();
        String[] stringOperands = script.getStringOperands();
        Map<Integer, Integer>[] switches = script.getSwitches();
        OutputStream out = new OutputStream();
        out.writeByte(0);
        block4: for (int i = 0; i < instructions.length; ++i) {
            int opcode = instructions[i];
            out.writeShort(opcode);
            switch (opcode) {
                case 3: {
                    out.writeString(stringOperands[i]);
                    continue block4;
                }
                case 21: 
                case 38: 
                case 39: 
                case 63: {
                    out.writeByte(intOperands[i]);
                    continue block4;
                }
                default: {
                    if (opcode < 100) {
                        out.writeInt(intOperands[i]);
                        continue block4;
                    }
                    out.writeByte(intOperands[i]);
                }
            }
        }
        out.writeInt(instructions.length);
        out.writeShort(script.getLocalIntCount());
        out.writeShort(script.getLocalObjCount());
        out.writeShort(script.getIntArgCount());
        out.writeShort(script.getObjArgCount());
        int switchStart = out.getOffset();
        if (switches == null) {
            out.writeByte(0);
        } else {
            out.writeByte(switches.length);
            for (Map<Integer, Integer> s : switches) {
                out.writeShort(s.size());
                for (Map.Entry<Integer, Integer> e : s.entrySet()) {
                    out.writeInt(e.getKey());
                    out.writeInt(e.getValue());
                }
            }
        }
        int switchLength = out.getOffset() - switchStart;
        out.writeShort(switchLength);
        return out.flip();
    }
}

