/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache.definitions.loaders;

import java.util.LinkedList;
import net.runelite.cache.definitions.WorldMapDefinition;
import net.runelite.cache.definitions.WorldMapType0;
import net.runelite.cache.definitions.WorldMapType1;
import net.runelite.cache.definitions.WorldMapType2;
import net.runelite.cache.definitions.WorldMapType3;
import net.runelite.cache.definitions.WorldMapTypeBase;
import net.runelite.cache.io.InputStream;
import net.runelite.cache.region.Position;

public class WorldMapLoader {
    public WorldMapDefinition load(byte[] b, int fileId) {
        WorldMapDefinition def = new WorldMapDefinition();
        InputStream in = new InputStream(b);
        def.fileId = fileId;
        def.safeName = in.readString();
        def.name = in.readString();
        int packedPos = in.readInt();
        def.position = Position.fromPacked(packedPos);
        def.emptyTileColor = in.readInt();
        def.backgroundColor = in.readInt();
        in.readUnsignedByte();
        def.isSurface = in.readUnsignedByte() == 1;
        def.defaultZoom = in.readUnsignedByte();
        int var3 = in.readUnsignedByte();
        def.regionList = new LinkedList<WorldMapTypeBase>();
        for (int var4 = 0; var4 < var3; ++var4) {
            def.regionList.add(this.loadType(in));
        }
        return def;
    }

    private WorldMapTypeBase loadType(InputStream var1) {
        WorldMapTypeBase base;
        int var2 = var1.readUnsignedByte();
        switch (var2) {
            case 0: {
                base = this.load1(var1);
                break;
            }
            case 1: {
                base = this.load2(var1);
                break;
            }
            case 2: {
                base = this.load3(var1);
                break;
            }
            case 3: {
                base = this.load0(var1);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return base;
    }

    private WorldMapTypeBase load0(InputStream in) {
        WorldMapType0 wm = new WorldMapType0();
        wm.plane = in.readUnsignedByte();
        wm.numberOfPlanes = in.readUnsignedByte();
        wm.xLow = in.readUnsignedShort();
        wm.chunk_xLow = in.readUnsignedByte();
        wm.yLow = in.readUnsignedShort();
        wm.chunk_yLow = in.readUnsignedByte();
        wm.xHigh = in.readUnsignedShort();
        wm.chunk_xHigh = in.readUnsignedByte();
        wm.yHigh = in.readUnsignedShort();
        wm.chunk_yHigh = in.readUnsignedByte();
        return wm;
    }

    private WorldMapTypeBase load1(InputStream in) {
        WorldMapType1 wm = new WorldMapType1();
        wm.plane = in.readUnsignedByte();
        wm.numberOfPlanes = in.readUnsignedByte();
        wm.xLowerLeft = in.readUnsignedShort();
        wm.yLowerLeft = in.readUnsignedShort();
        wm.xLowerRight = in.readUnsignedShort();
        wm.yUpperLeft = in.readUnsignedShort();
        wm.xUpperLeft = in.readUnsignedShort();
        wm.yLowerRight = in.readUnsignedShort();
        wm.xUpperRight = in.readUnsignedShort();
        wm.yUpperRight = in.readUnsignedShort();
        return wm;
    }

    private WorldMapTypeBase load2(InputStream in) {
        WorldMapType2 wm = new WorldMapType2();
        wm.plane = in.readUnsignedByte();
        wm.numberOfPlanes = in.readUnsignedByte();
        wm.xLow = in.readUnsignedShort();
        wm.yLow = in.readUnsignedShort();
        wm.xHigh = in.readUnsignedShort();
        wm.yHigh = in.readUnsignedShort();
        return wm;
    }

    private WorldMapTypeBase load3(InputStream in) {
        WorldMapType3 wm = new WorldMapType3();
        wm.oldPlane = in.readUnsignedByte();
        wm.numberOfPlanes = in.readUnsignedByte();
        wm.oldX = in.readUnsignedShort();
        wm.chunk_oldXLow = in.readUnsignedByte();
        wm.chunk_oldXHigh = in.readUnsignedByte();
        wm.oldY = in.readUnsignedShort();
        wm.chunk_oldYLow = in.readUnsignedByte();
        wm.chunk_oldYHigh = in.readUnsignedByte();
        wm.newX = in.readUnsignedShort();
        wm.chunk_newXLow = in.readUnsignedByte();
        wm.chunk_newXHigh = in.readUnsignedByte();
        wm.newY = in.readUnsignedShort();
        wm.chunk_newYLow = in.readUnsignedByte();
        wm.chunk_newYHigh = in.readUnsignedByte();
        return wm;
    }
}

