/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache.definitions.loaders;

import net.runelite.cache.definitions.MapSquareDefinition;
import net.runelite.cache.definitions.ZoneDefinition;
import net.runelite.cache.io.InputStream;

public class WorldMapDataLoader {
    public MapSquareDefinition loadMapSquare(InputStream in) {
        int worldMapDataType = in.readUnsignedByte();
        if (worldMapDataType != 0) {
            throw new RuntimeException("Expected worldMapDataType 0 got " + worldMapDataType);
        }
        MapSquareDefinition mapSquareDefinition = new MapSquareDefinition();
        mapSquareDefinition.minLevel = in.readUnsignedByte();
        mapSquareDefinition.levels = in.readUnsignedByte();
        mapSquareDefinition.sourceSquareX = in.readUnsignedShort();
        mapSquareDefinition.sourceSquareZ = in.readUnsignedShort();
        mapSquareDefinition.displaySquareX = in.readUnsignedShort();
        mapSquareDefinition.displaySquareZ = in.readUnsignedShort();
        mapSquareDefinition.groupId = in.readBigSmart2();
        mapSquareDefinition.fileId = in.readBigSmart2();
        return mapSquareDefinition;
    }

    public ZoneDefinition loadZone(InputStream in) {
        int worldMapDataType = in.readUnsignedByte();
        if (worldMapDataType != 1) {
            throw new RuntimeException("Expected worldMapDataType 1 got " + worldMapDataType);
        }
        ZoneDefinition zoneDefinition = new ZoneDefinition();
        zoneDefinition.minLevel = in.readUnsignedByte();
        zoneDefinition.levels = in.readUnsignedByte();
        zoneDefinition.sourceSquareX = in.readUnsignedShort();
        zoneDefinition.sourceSquareZ = in.readUnsignedShort();
        zoneDefinition.sourceZoneX = in.readUnsignedByte();
        zoneDefinition.sourceZoneZ = in.readUnsignedByte();
        zoneDefinition.displaySquareX = in.readUnsignedShort();
        zoneDefinition.displaySquareZ = in.readUnsignedShort();
        zoneDefinition.displayZoneX = in.readUnsignedByte();
        zoneDefinition.displayZoneZ = in.readUnsignedByte();
        zoneDefinition.groupId = in.readBigSmart2();
        zoneDefinition.fileId = in.readBigSmart2();
        return zoneDefinition;
    }
}

