/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache.definitions.loaders;

import net.runelite.cache.definitions.WorldMapCompositeDefinition;
import net.runelite.cache.definitions.WorldMapElementDefinition;
import net.runelite.cache.definitions.loaders.WorldMapDataLoader;
import net.runelite.cache.definitions.loaders.WorldMapElementLoader;
import net.runelite.cache.io.InputStream;
import net.runelite.cache.region.Position;

public class WorldMapCompositeLoader {
    public WorldMapCompositeDefinition load(byte[] buffer) {
        WorldMapDataLoader worldMapDataLoader = new WorldMapDataLoader();
        WorldMapElementLoader worldMapElementLoader = new WorldMapElementLoader();
        WorldMapCompositeDefinition worldMapCompositeDefinition = new WorldMapCompositeDefinition();
        InputStream in = new InputStream(buffer);
        int worldData0Count = in.readUnsignedShort();
        for (int i = 0; i < worldData0Count; ++i) {
            worldMapCompositeDefinition.mapSquareDefinitions.add(worldMapDataLoader.loadMapSquare(in));
        }
        int worldData1Amount = in.readUnsignedShort();
        for (int i = 0; i < worldData1Amount; ++i) {
            worldMapCompositeDefinition.zoneDefinitions.add(worldMapDataLoader.loadZone(in));
        }
        int iconAmount = in.readUnsignedShort();
        for (int i = 0; i < iconAmount; ++i) {
            worldMapCompositeDefinition.worldMapElementDefinitions.add(worldMapElementLoader.load(in));
        }
        for (WorldMapElementDefinition element : worldMapCompositeDefinition.worldMapElementDefinitions) {
            Position position = element.getPosition();
            element.setOffset(worldMapCompositeDefinition.calculateWorldOffset(position));
        }
        return worldMapCompositeDefinition;
    }
}

