/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache.definitions.loaders;

import java.util.HashMap;
import net.runelite.cache.definitions.StructDefinition;
import net.runelite.cache.io.InputStream;

public class StructLoader {
    public StructDefinition load(int id, byte[] b) {
        int opcode;
        StructDefinition def = new StructDefinition(id);
        InputStream is = new InputStream(b);
        while ((opcode = is.readUnsignedByte()) != 0) {
            this.decodeValues(opcode, def, is);
        }
        return def;
    }

    private void decodeValues(int opcode, StructDefinition def, InputStream stream) {
        if (opcode == 249) {
            int length = stream.readUnsignedByte();
            def.params = new HashMap<Integer, Object>(length);
            for (int i = 0; i < length; ++i) {
                boolean isString = stream.readUnsignedByte() == 1;
                int key = stream.read24BitInt();
                Object value = isString ? stream.readString() : Integer.valueOf(stream.readInt());
                def.params.put(key, value);
            }
        }
    }
}

