/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache.definitions.loaders;

import net.runelite.cache.definitions.SequenceDefinition;
import net.runelite.cache.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceLoader {
    private static final Logger log = LoggerFactory.getLogger(SequenceLoader.class);
    public static final int REV_220_SEQ_ARCHIVE_REV = 1141;
    public static final int REV_226_SEQ_ARCHIVE_REV = 1268;
    private boolean rev220FrameSounds = true;
    private boolean rev226 = true;

    public SequenceLoader configureForRevision(int rev) {
        this.rev220FrameSounds = rev > 1141;
        this.rev226 = rev > 1268;
        return this;
    }

    public SequenceDefinition load(int id, byte[] b) {
        int opcode;
        SequenceDefinition def = new SequenceDefinition(id);
        InputStream is = new InputStream(b);
        while ((opcode = is.readUnsignedByte()) != 0) {
            this.decodeValues(opcode, def, is);
        }
        return def;
    }

    private void decodeValues(int opcode, SequenceDefinition def, InputStream stream) {
        if (opcode == 1) {
            int var4;
            int var3 = stream.readUnsignedShort();
            def.frameLengths = new int[var3];
            for (var4 = 0; var4 < var3; ++var4) {
                def.frameLengths[var4] = stream.readUnsignedShort();
            }
            def.frameIDs = new int[var3];
            for (var4 = 0; var4 < var3; ++var4) {
                def.frameIDs[var4] = stream.readUnsignedShort();
            }
            var4 = 0;
            while (var4 < var3) {
                int n = var4++;
                def.frameIDs[n] = def.frameIDs[n] + (stream.readUnsignedShort() << 16);
            }
        } else if (opcode == 2) {
            def.frameStep = stream.readUnsignedShort();
        } else if (opcode == 3) {
            int var3 = stream.readUnsignedByte();
            def.interleaveLeave = new int[1 + var3];
            for (int var4 = 0; var4 < var3; ++var4) {
                def.interleaveLeave[var4] = stream.readUnsignedByte();
            }
            def.interleaveLeave[var3] = 9999999;
        } else if (opcode == 4) {
            def.stretches = true;
        } else if (opcode == 5) {
            def.forcedPriority = stream.readUnsignedByte();
        } else if (opcode == 6) {
            def.leftHandItem = stream.readUnsignedShort();
        } else if (opcode == 7) {
            def.rightHandItem = stream.readUnsignedShort();
        } else if (opcode == 8) {
            def.maxLoops = stream.readUnsignedByte();
        } else if (opcode == 9) {
            def.precedenceAnimating = stream.readUnsignedByte();
        } else if (opcode == 10) {
            def.priority = stream.readUnsignedByte();
        } else if (opcode == 11) {
            def.replyMode = stream.readUnsignedByte();
        } else if (opcode == 12) {
            int var4;
            int var3 = stream.readUnsignedByte();
            def.chatFrameIds = new int[var3];
            for (var4 = 0; var4 < var3; ++var4) {
                def.chatFrameIds[var4] = stream.readUnsignedShort();
            }
            var4 = 0;
            while (var4 < var3) {
                int n = var4++;
                def.chatFrameIds[n] = def.chatFrameIds[n] + (stream.readUnsignedShort() << 16);
            }
        } else if (opcode == 13 && !this.rev226) {
            int var3 = stream.readUnsignedByte();
            for (int var4 = 0; var4 < var3; ++var4) {
                def.frameSounds.put((Object)var4, (Object)this.readFrameSound(stream));
            }
        } else if (opcode == (this.rev226 ? 13 : 14)) {
            def.animMayaID = stream.readInt();
        } else if (opcode == (this.rev226 ? 14 : 15)) {
            int var3 = stream.readUnsignedShort();
            for (int var4 = 0; var4 < var3; ++var4) {
                int frame = stream.readUnsignedShort();
                def.frameSounds.put((Object)frame, (Object)this.readFrameSound(stream));
            }
        } else if (opcode == (this.rev226 ? 15 : 16)) {
            def.animMayaStart = stream.readUnsignedShort();
            def.animMayaEnd = stream.readUnsignedShort();
        } else if (opcode == 16) {
            def.verticalOffset = stream.readByte();
        } else if (opcode == 17) {
            def.animMayaMasks = new boolean[256];
            int var3 = stream.readUnsignedByte();
            for (int var4 = 0; var4 < var3; ++var4) {
                def.animMayaMasks[stream.readUnsignedByte()] = true;
            }
        } else if (opcode == 18) {
            def.debugName = stream.readString();
        } else if (opcode == 19) {
            def.soundsCrossWorldView = true;
        } else {
            log.warn("Unrecognized opcode {}", (Object)opcode);
        }
    }

    private SequenceDefinition.Sound readFrameSound(InputStream stream) {
        int retain;
        int loops;
        int id;
        int location;
        int weight = -1;
        if (!this.rev220FrameSounds) {
            int bits = stream.read24BitInt();
            location = bits & 0xF;
            id = bits >> 8;
            loops = bits >> 4 & 7;
            retain = 0;
        } else {
            id = stream.readUnsignedShort();
            if (this.rev226) {
                weight = stream.readUnsignedByte();
            }
            loops = stream.readUnsignedByte();
            location = stream.readUnsignedByte();
            retain = stream.readUnsignedByte();
        }
        if (id >= 1 && loops >= 1 && location >= 0 && retain >= 0) {
            return new SequenceDefinition.Sound(id, loops, location, retain, weight);
        }
        return null;
    }

    public boolean isRev220FrameSounds() {
        return this.rev220FrameSounds;
    }

    public boolean isRev226() {
        return this.rev226;
    }

    public SequenceLoader setRev220FrameSounds(boolean rev220FrameSounds) {
        this.rev220FrameSounds = rev220FrameSounds;
        return this;
    }

    public SequenceLoader setRev226(boolean rev226) {
        this.rev226 = rev226;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SequenceLoader)) {
            return false;
        }
        SequenceLoader other = (SequenceLoader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isRev220FrameSounds() != other.isRev220FrameSounds()) {
            return false;
        }
        return this.isRev226() == other.isRev226();
    }

    protected boolean canEqual(Object other) {
        return other instanceof SequenceLoader;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isRev220FrameSounds() ? 79 : 97);
        result = result * 59 + (this.isRev226() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "SequenceLoader(rev220FrameSounds=" + this.isRev220FrameSounds() + ", rev226=" + this.isRev226() + ")";
    }
}

