/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache.definitions.loaders;

import net.runelite.cache.definitions.MapDefinition;
import net.runelite.cache.io.InputStream;

public class MapLoader {
    public MapDefinition load(int regionX, int regionY, byte[] b) {
        MapDefinition map = new MapDefinition();
        map.setRegionX(regionX);
        map.setRegionY(regionY);
        this.loadTerrain(map, b);
        return map;
    }

    private void loadTerrain(MapDefinition map, byte[] buf) {
        MapDefinition.Tile[][][] tiles = map.getTiles();
        InputStream in = new InputStream(buf);
        for (int z = 0; z < 4; ++z) {
            for (int x = 0; x < 64; ++x) {
                block2: for (int y = 0; y < 64; ++y) {
                    int attribute;
                    MapDefinition.Tile tile = new MapDefinition.Tile();
                    tiles[z][x][y] = tile;
                    MapDefinition.Tile tile2 = tile;
                    while ((attribute = in.readUnsignedShort()) != 0) {
                        if (attribute == 1) {
                            int height = in.readUnsignedByte();
                            tile2.height = height;
                            continue block2;
                        }
                        if (attribute <= 49) {
                            tile2.attrOpcode = attribute;
                            tile2.overlayId = in.readShort();
                            tile2.overlayPath = (byte)((attribute - 2) / 4);
                            tile2.overlayRotation = (byte)(attribute - 2 & 3);
                            continue;
                        }
                        if (attribute <= 81) {
                            tile2.settings = (byte)(attribute - 49);
                            continue;
                        }
                        tile2.underlayId = (short)(attribute - 81);
                    }
                }
            }
        }
    }
}

