/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache.definitions.loaders;

import net.runelite.cache.definitions.LocationsDefinition;
import net.runelite.cache.io.InputStream;
import net.runelite.cache.region.Location;
import net.runelite.cache.region.Position;

public class LocationsLoader {
    public LocationsDefinition load(int regionX, int regionY, byte[] b) {
        LocationsDefinition loc = new LocationsDefinition();
        loc.setRegionX(regionX);
        loc.setRegionY(regionY);
        this.loadLocations(loc, b);
        return loc;
    }

    private void loadLocations(LocationsDefinition loc, byte[] b) {
        int idOffset;
        InputStream buf = new InputStream(b);
        int id = -1;
        while ((idOffset = buf.readUnsignedIntSmartShortCompat()) != 0) {
            int positionOffset;
            id += idOffset;
            int position = 0;
            while ((positionOffset = buf.readUnsignedShortSmart()) != 0) {
                int localY = (position += positionOffset - 1) & 0x3F;
                int localX = position >> 6 & 0x3F;
                int height = position >> 12 & 3;
                int attributes = buf.readUnsignedByte();
                int type = attributes >> 2;
                int orientation = attributes & 3;
                loc.getLocations().add(new Location(id, type, orientation, new Position(localX, localY, height)));
            }
        }
    }
}

