/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache.definitions.loaders;

import net.runelite.cache.definitions.KitDefinition;
import net.runelite.cache.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KitLoader {
    private static final Logger logger = LoggerFactory.getLogger(KitLoader.class);

    public KitDefinition load(int id, byte[] b) {
        int opcode;
        KitDefinition def = new KitDefinition(id);
        InputStream is = new InputStream(b);
        while ((opcode = is.readUnsignedByte()) != 0) {
            int index;
            int length;
            if (opcode == 1) {
                def.bodyPartId = is.readUnsignedByte();
                continue;
            }
            if (opcode == 2) {
                length = is.readUnsignedByte();
                def.models = new int[length];
                for (index = 0; index < length; ++index) {
                    def.models[index] = is.readUnsignedShort();
                }
                continue;
            }
            if (opcode == 3) {
                def.nonSelectable = true;
                continue;
            }
            if (opcode == 40) {
                length = is.readUnsignedByte();
                def.recolorToFind = new short[length];
                def.recolorToReplace = new short[length];
                for (index = 0; index < length; ++index) {
                    def.recolorToFind[index] = is.readShort();
                    def.recolorToReplace[index] = is.readShort();
                }
                continue;
            }
            if (opcode == 41) {
                length = is.readUnsignedByte();
                def.retextureToFind = new short[length];
                def.retextureToReplace = new short[length];
                for (index = 0; index < length; ++index) {
                    def.retextureToFind[index] = is.readShort();
                    def.retextureToReplace[index] = is.readShort();
                }
                continue;
            }
            if (opcode < 60 || opcode >= 70) continue;
            def.chatheadModels[opcode - 60] = is.readUnsignedShort();
        }
        return def;
    }
}

