/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache.definitions.loaders;

import java.util.ArrayList;
import java.util.Arrays;
import net.runelite.cache.definitions.ClientScript1Instruction;
import net.runelite.cache.definitions.InterfaceDefinition;
import net.runelite.cache.io.InputStream;

public class InterfaceLoader {
    public InterfaceDefinition load(int id, byte[] b) {
        InterfaceDefinition iface = new InterfaceDefinition();
        iface.id = id;
        if (b[0] == -1) {
            this.decodeIf3(iface, new InputStream(b));
        } else {
            this.decodeIf1(iface, new InputStream(b));
        }
        return iface;
    }

    private void decodeIf1(InterfaceDefinition iface, InputStream var1) {
        int var6;
        int var5;
        int var4;
        int var3;
        int var2;
        iface.isIf3 = false;
        iface.type = var1.readUnsignedByte();
        iface.menuType = var1.readUnsignedByte();
        iface.contentType = var1.readUnsignedShort();
        iface.originalX = var1.readShort();
        iface.originalY = var1.readShort();
        iface.originalWidth = var1.readUnsignedShort();
        iface.originalHeight = var1.readUnsignedShort();
        iface.opacity = var1.readUnsignedByte();
        iface.parentId = var1.readUnsignedShort();
        iface.parentId = iface.parentId == 65535 ? -1 : (iface.parentId += iface.id & 0xFFFF0000);
        iface.hoveredSiblingId = var1.readUnsignedShort();
        if (iface.hoveredSiblingId == 65535) {
            iface.hoveredSiblingId = -1;
        }
        if ((var2 = var1.readUnsignedByte()) > 0) {
            iface.alternateOperators = new int[var2];
            iface.alternateRhs = new int[var2];
            for (var3 = 0; var3 < var2; ++var3) {
                iface.alternateOperators[var3] = var1.readUnsignedByte();
                iface.alternateRhs[var3] = var1.readUnsignedShort();
            }
        }
        if ((var3 = var1.readUnsignedByte()) > 0) {
            iface.clientScripts = new ClientScript1Instruction[var3][];
            for (var4 = 0; var4 < var3; ++var4) {
                var5 = var1.readUnsignedShort();
                int[] bytecode = new int[var5];
                for (var6 = 0; var6 < var5; ++var6) {
                    int ac;
                    bytecode[var6] = var1.readUnsignedShort();
                    if (bytecode[var6] == 65535) {
                        bytecode[var6] = -1;
                    }
                    ArrayList<ClientScript1Instruction> instructions = new ArrayList<ClientScript1Instruction>();
                    for (int i = 0; i < bytecode.length; i += ac) {
                        ClientScript1Instruction ins = new ClientScript1Instruction();
                        ins.opcode = ClientScript1Instruction.Opcode.values()[bytecode[i++]];
                        ac = ins.opcode.argumentCount;
                        ins.operands = Arrays.copyOfRange(bytecode, i, i + ac);
                        instructions.add(ins);
                    }
                    iface.clientScripts[var4] = instructions.toArray(new ClientScript1Instruction[0]);
                }
            }
        }
        if (iface.type == 0) {
            iface.scrollHeight = var1.readUnsignedShort();
            boolean bl = iface.isHidden = var1.readUnsignedByte() == 1;
        }
        if (iface.type == 1) {
            var1.readUnsignedShort();
            var1.readUnsignedByte();
        }
        if (iface.type == 2) {
            int var8;
            int var7;
            iface.itemIds = new int[iface.originalWidth * iface.originalHeight];
            iface.itemQuantities = new int[iface.originalHeight * iface.originalWidth];
            var4 = var1.readUnsignedByte();
            if (var4 == 1) {
                iface.clickMask |= 0x10000000;
            }
            if ((var5 = var1.readUnsignedByte()) == 1) {
                iface.clickMask |= 0x40000000;
            }
            if ((var6 = var1.readUnsignedByte()) == 1) {
                iface.clickMask |= Integer.MIN_VALUE;
            }
            if ((var7 = var1.readUnsignedByte()) == 1) {
                iface.clickMask |= 0x20000000;
            }
            iface.xPitch = var1.readUnsignedByte();
            iface.yPitch = var1.readUnsignedByte();
            iface.xOffsets = new int[20];
            iface.yOffsets = new int[20];
            iface.sprites = new int[20];
            for (var8 = 0; var8 < 20; ++var8) {
                int var9 = var1.readUnsignedByte();
                if (var9 == 1) {
                    iface.xOffsets[var8] = var1.readShort();
                    iface.yOffsets[var8] = var1.readShort();
                    iface.sprites[var8] = var1.readInt();
                    continue;
                }
                iface.sprites[var8] = -1;
            }
            iface.configActions = new String[5];
            for (var8 = 0; var8 < 5; ++var8) {
                String var11 = var1.readString();
                if (var11.length() <= 0) continue;
                iface.configActions[var8] = var11;
                iface.clickMask |= 1 << var8 + 23;
            }
        }
        if (iface.type == 3) {
            boolean bl = iface.filled = var1.readUnsignedByte() == 1;
        }
        if (iface.type == 4 || iface.type == 1) {
            iface.xTextAlignment = var1.readUnsignedByte();
            iface.yTextAlignment = var1.readUnsignedByte();
            iface.lineHeight = var1.readUnsignedByte();
            iface.fontId = var1.readUnsignedShort();
            if (iface.fontId == 65535) {
                iface.fontId = -1;
            }
            boolean bl = iface.textShadowed = var1.readUnsignedByte() == 1;
        }
        if (iface.type == 4) {
            iface.text = var1.readString();
            iface.alternateText = var1.readString();
        }
        if (iface.type == 1 || iface.type == 3 || iface.type == 4) {
            iface.textColor = var1.readInt();
        }
        if (iface.type == 3 || iface.type == 4) {
            iface.alternateTextColor = var1.readInt();
            iface.hoveredTextColor = var1.readInt();
            iface.alternateHoveredTextColor = var1.readInt();
        }
        if (iface.type == 5) {
            iface.spriteId = var1.readInt();
            iface.alternateSpriteId = var1.readInt();
        }
        if (iface.type == 6) {
            iface.modelType = 1;
            iface.modelId = var1.readUnsignedShort();
            if (iface.modelId == 65535) {
                iface.modelId = -1;
            }
            iface.alternateModelId = var1.readUnsignedShort();
            if (iface.alternateModelId == 65535) {
                iface.alternateModelId = -1;
            }
            iface.animation = var1.readUnsignedShort();
            if (iface.animation == 65535) {
                iface.animation = -1;
            }
            iface.alternateAnimation = var1.readUnsignedShort();
            if (iface.alternateAnimation == 65535) {
                iface.alternateAnimation = -1;
            }
            iface.modelZoom = var1.readUnsignedShort();
            iface.rotationX = var1.readUnsignedShort();
            iface.rotationZ = var1.readUnsignedShort();
        }
        if (iface.type == 7) {
            iface.itemIds = new int[iface.originalWidth * iface.originalHeight];
            iface.itemQuantities = new int[iface.originalWidth * iface.originalHeight];
            iface.xTextAlignment = var1.readUnsignedByte();
            iface.fontId = var1.readUnsignedShort();
            if (iface.fontId == 65535) {
                iface.fontId = -1;
            }
            iface.textShadowed = var1.readUnsignedByte() == 1;
            iface.textColor = var1.readInt();
            iface.xPitch = var1.readShort();
            iface.yPitch = var1.readShort();
            var4 = var1.readUnsignedByte();
            if (var4 == 1) {
                iface.clickMask |= 0x40000000;
            }
            iface.configActions = new String[5];
            for (var5 = 0; var5 < 5; ++var5) {
                String var10 = var1.readString();
                if (var10.length() <= 0) continue;
                iface.configActions[var5] = var10;
                iface.clickMask |= 1 << var5 + 23;
            }
        }
        if (iface.type == 8) {
            iface.text = var1.readString();
        }
        if (iface.menuType == 2 || iface.type == 2) {
            iface.targetVerb = var1.readString();
            iface.spellName = var1.readString();
            var4 = var1.readUnsignedShort() & 0x3F;
            iface.clickMask |= var4 << 11;
        }
        if (iface.menuType == 1 || iface.menuType == 4 || iface.menuType == 5 || iface.menuType == 6) {
            iface.tooltip = var1.readString();
            if (iface.tooltip.length() == 0) {
                if (iface.menuType == 1) {
                    iface.tooltip = "Ok";
                }
                if (iface.menuType == 4) {
                    iface.tooltip = "Select";
                }
                if (iface.menuType == 5) {
                    iface.tooltip = "Select";
                }
                if (iface.menuType == 6) {
                    iface.tooltip = "Continue";
                }
            }
        }
        if (iface.menuType == 1 || iface.menuType == 4 || iface.menuType == 5) {
            iface.clickMask |= 0x400000;
        }
        if (iface.menuType == 6) {
            iface.clickMask |= 1;
        }
    }

    private void decodeIf3(InterfaceDefinition iface, InputStream var1) {
        var1.readUnsignedByte();
        iface.isIf3 = true;
        iface.type = var1.readUnsignedByte();
        iface.contentType = var1.readUnsignedShort();
        iface.originalX = var1.readShort();
        iface.originalY = var1.readShort();
        iface.originalWidth = var1.readUnsignedShort();
        iface.originalHeight = iface.type == 9 ? (int)var1.readShort() : var1.readUnsignedShort();
        iface.widthMode = var1.readByte();
        iface.heightMode = var1.readByte();
        iface.xPositionMode = var1.readByte();
        iface.yPositionMode = var1.readByte();
        iface.parentId = var1.readUnsignedShort();
        iface.parentId = iface.parentId == 65535 ? -1 : (iface.parentId += iface.id & 0xFFFF0000);
        boolean bl = iface.isHidden = var1.readUnsignedByte() == 1;
        if (iface.type == 0) {
            iface.scrollWidth = var1.readUnsignedShort();
            iface.scrollHeight = var1.readUnsignedShort();
            boolean bl2 = iface.noClickThrough = var1.readUnsignedByte() == 1;
        }
        if (iface.type == 5) {
            iface.spriteId = var1.readInt();
            iface.textureId = var1.readUnsignedShort();
            iface.spriteTiling = var1.readUnsignedByte() == 1;
            iface.opacity = var1.readUnsignedByte();
            iface.borderType = var1.readUnsignedByte();
            iface.shadowColor = var1.readInt();
            iface.flippedVertically = var1.readUnsignedByte() == 1;
            boolean bl3 = iface.flippedHorizontally = var1.readUnsignedByte() == 1;
        }
        if (iface.type == 6) {
            iface.modelType = 1;
            iface.modelId = var1.readUnsignedShort();
            if (iface.modelId == 65535) {
                iface.modelId = -1;
            }
            iface.offsetX2d = var1.readShort();
            iface.offsetY2d = var1.readShort();
            iface.rotationX = var1.readUnsignedShort();
            iface.rotationZ = var1.readUnsignedShort();
            iface.rotationY = var1.readUnsignedShort();
            iface.modelZoom = var1.readUnsignedShort();
            iface.animation = var1.readUnsignedShort();
            if (iface.animation == 65535) {
                iface.animation = -1;
            }
            iface.orthogonal = var1.readUnsignedByte() == 1;
            var1.readUnsignedShort();
            if (iface.widthMode != 0) {
                iface.modelHeightOverride = var1.readUnsignedShort();
            }
            if (iface.heightMode != 0) {
                var1.readUnsignedShort();
            }
        }
        if (iface.type == 4) {
            iface.fontId = var1.readUnsignedShort();
            if (iface.fontId == 65535) {
                iface.fontId = -1;
            }
            iface.text = var1.readString();
            iface.lineHeight = var1.readUnsignedByte();
            iface.xTextAlignment = var1.readUnsignedByte();
            iface.yTextAlignment = var1.readUnsignedByte();
            iface.textShadowed = var1.readUnsignedByte() == 1;
            iface.textColor = var1.readInt();
        }
        if (iface.type == 3) {
            iface.textColor = var1.readInt();
            iface.filled = var1.readUnsignedByte() == 1;
            iface.opacity = var1.readUnsignedByte();
        }
        if (iface.type == 9) {
            iface.lineWidth = var1.readUnsignedByte();
            iface.textColor = var1.readInt();
            iface.lineDirection = var1.readUnsignedByte() == 1;
        }
        iface.clickMask = var1.read24BitInt();
        iface.name = var1.readString();
        int var2 = var1.readUnsignedByte();
        if (var2 > 0) {
            iface.actions = new String[var2];
            for (int var3 = 0; var3 < var2; ++var3) {
                iface.actions[var3] = var1.readString();
            }
        }
        iface.dragDeadZone = var1.readUnsignedByte();
        iface.dragDeadTime = var1.readUnsignedByte();
        iface.dragRenderBehavior = var1.readUnsignedByte() == 1;
        iface.targetVerb = var1.readString();
        iface.onLoadListener = this.decodeListener(iface, var1);
        iface.onMouseOverListener = this.decodeListener(iface, var1);
        iface.onMouseLeaveListener = this.decodeListener(iface, var1);
        iface.onTargetLeaveListener = this.decodeListener(iface, var1);
        iface.onTargetEnterListener = this.decodeListener(iface, var1);
        iface.onVarTransmitListener = this.decodeListener(iface, var1);
        iface.onInvTransmitListener = this.decodeListener(iface, var1);
        iface.onStatTransmitListener = this.decodeListener(iface, var1);
        iface.onTimerListener = this.decodeListener(iface, var1);
        iface.onOpListener = this.decodeListener(iface, var1);
        iface.onMouseRepeatListener = this.decodeListener(iface, var1);
        iface.onClickListener = this.decodeListener(iface, var1);
        iface.onClickRepeatListener = this.decodeListener(iface, var1);
        iface.onReleaseListener = this.decodeListener(iface, var1);
        iface.onHoldListener = this.decodeListener(iface, var1);
        iface.onDragListener = this.decodeListener(iface, var1);
        iface.onDragCompleteListener = this.decodeListener(iface, var1);
        iface.onScrollWheelListener = this.decodeListener(iface, var1);
        iface.varTransmitTriggers = this.decodeTriggers(var1);
        iface.invTransmitTriggers = this.decodeTriggers(var1);
        iface.statTransmitTriggers = this.decodeTriggers(var1);
    }

    private Object[] decodeListener(InterfaceDefinition iface, InputStream var1) {
        int var2 = var1.readUnsignedByte();
        if (var2 == 0) {
            return null;
        }
        Object[] var3 = new Object[var2];
        for (int var4 = 0; var4 < var2; ++var4) {
            int var5 = var1.readUnsignedByte();
            if (var5 == 0) {
                var3[var4] = new Integer(var1.readInt());
                continue;
            }
            if (var5 != 1) continue;
            var3[var4] = var1.readString();
        }
        iface.hasListener = true;
        return var3;
    }

    private int[] decodeTriggers(InputStream var1) {
        int var2 = var1.readUnsignedByte();
        if (var2 == 0) {
            return null;
        }
        int[] var3 = new int[var2];
        for (int var4 = 0; var4 < var2; ++var4) {
            var3[var4] = var1.readInt();
        }
        return var3;
    }
}

