/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache.definitions.loaders;

import net.runelite.cache.definitions.HitSplatDefinition;
import net.runelite.cache.io.InputStream;

public class HitSplatLoader {
    public HitSplatDefinition load(byte[] data) {
        HitSplatDefinition def = new HitSplatDefinition();
        InputStream stream = new InputStream(data);
        while (true) {
            int opcode = stream.readUnsignedByte();
            switch (opcode) {
                case 0: {
                    return def;
                }
                case 1: {
                    def.setFontType(stream.readBigSmart2());
                    break;
                }
                case 2: {
                    def.setTextColor(stream.read24BitInt());
                    break;
                }
                case 3: {
                    def.setLeftSprite(stream.readBigSmart2());
                    break;
                }
                case 4: {
                    def.setLeftSprite2(stream.readBigSmart2());
                    break;
                }
                case 5: {
                    def.setBackgroundSprite(stream.readBigSmart2());
                    break;
                }
                case 6: {
                    def.setRightSpriteId(stream.readBigSmart2());
                    break;
                }
                case 7: {
                    def.setScrollToOffsetX(stream.readShort());
                    break;
                }
                case 8: {
                    def.setStringFormat(stream.readString2());
                    break;
                }
                case 9: {
                    def.setDisplayCycles(stream.readUnsignedShort());
                    break;
                }
                case 10: {
                    def.setScrollToOffsetY(stream.readShort());
                    break;
                }
                case 11: {
                    def.setFadeStartCycle(0);
                    break;
                }
                case 12: {
                    def.setUseDamage(stream.readUnsignedByte());
                    break;
                }
                case 13: {
                    def.setTextOffsetY(stream.readShort());
                    break;
                }
                case 14: {
                    def.setFadeStartCycle(stream.readUnsignedShort());
                    break;
                }
                case 17: 
                case 18: {
                    int varbitId = stream.readUnsignedShort();
                    if (varbitId == 65535) {
                        varbitId = -1;
                    }
                    def.setVarbitID(varbitId);
                    int varp = stream.readUnsignedShort();
                    if (varp == 65535) {
                        varp = -1;
                    }
                    def.setVarpID(varp);
                    int id = -1;
                    if (opcode == 18 && (id = stream.readUnsignedShort()) == 65535) {
                        id = -1;
                    }
                    int length = stream.readUnsignedByte();
                    int[] multihitsplats = new int[length + 2];
                    for (int i = 0; i <= length; ++i) {
                        multihitsplats[i] = stream.readUnsignedShort();
                        if (multihitsplats[i] != 65535) continue;
                        multihitsplats[i] = -1;
                    }
                    multihitsplats[length + 1] = id;
                    def.setMultihitsplats(multihitsplats);
                }
            }
        }
    }
}

