/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache.definitions.loaders;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import net.runelite.cache.definitions.GameValDefinition;
import net.runelite.cache.io.InputStream;

public class GameValLoader {
    public static final int ITEMS = 0;
    public static final int NPCS = 1;
    public static final int INVENTORIES = 2;
    public static final int VARPS = 3;
    public static final int VARBITS = 4;
    public static final int OBJECTS = 6;
    public static final int ANIMATIONS = 7;
    public static final int SPOTANIMS = 8;
    public static final int DBROWS = 9;
    public static final int DBTABLES = 10;
    public static final int JINGLES = 11;
    public static final int SPRITES = 12;
    public static final int INTERFACES_LEGACY = 13;
    public static final int INTERFACES = 14;
    public static final int VARCS = 15;

    public GameValDefinition load(int gameValId, int id, byte[] data) {
        GameValDefinition v = new GameValDefinition();
        v.setGameValId(gameValId);
        v.setId(id);
        if (gameValId == 10) {
            int counter;
            InputStream is = new InputStream(data);
            is.readUnsignedByte();
            v.setName(is.readString());
            v.setFiles(new HashMap<Integer, String>());
            int iid = 0;
            while ((counter = is.readUnsignedByte()) != 0) {
                v.getFiles().put(iid, is.readString());
                ++iid;
            }
        } else if (gameValId == 13) {
            int iid;
            InputStream is = new InputStream(data);
            v.setName(is.readString());
            v.setFiles(new HashMap<Integer, String>());
            int endIdx = data.length - 1;
            while (data[endIdx] != -1) {
                --endIdx;
            }
            int msb = 0;
            while ((iid = is.readUnsignedByte()) != 255 || is.getOffset() != endIdx + 1) {
                v.getFiles().put(msb | iid, is.readString());
                if (iid != 255) continue;
                msb += 256;
            }
        } else if (gameValId == 14) {
            int iid;
            InputStream is = new InputStream(data);
            v.setName(is.readString());
            v.setFiles(new HashMap<Integer, String>());
            while ((iid = is.readUnsignedShort()) != 65535) {
                v.getFiles().put(iid, is.readString());
            }
        } else {
            v.setName(new String(data, StandardCharsets.UTF_8));
        }
        return v;
    }
}

