/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache.definitions.loaders;

import net.runelite.cache.definitions.DBRowDefinition;
import net.runelite.cache.definitions.loaders.DBTableLoader;
import net.runelite.cache.io.InputStream;
import net.runelite.cache.util.ScriptVarType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBRowLoader {
    private static final Logger log = LoggerFactory.getLogger(DBRowLoader.class);

    public DBRowDefinition load(int id, byte[] b) {
        int opcode;
        DBRowDefinition def = new DBRowDefinition(id);
        InputStream is = new InputStream(b);
        while ((opcode = is.readUnsignedByte()) != 0) {
            this.decode(opcode, def, is);
        }
        return def;
    }

    private void decode(int opcode, DBRowDefinition def, InputStream stream) {
        switch (opcode) {
            case 3: {
                int numColumns = stream.readUnsignedByte();
                ScriptVarType[][] types = new ScriptVarType[numColumns][];
                Object[][] columnValues = new Object[numColumns][];
                int columnId = stream.readUnsignedByte();
                while (columnId != 255) {
                    ScriptVarType[] columnTypes = new ScriptVarType[stream.readUnsignedByte()];
                    for (int i = 0; i < columnTypes.length; ++i) {
                        columnTypes[i] = ScriptVarType.forId(stream.readUnsignedShortSmart());
                    }
                    types[columnId] = columnTypes;
                    columnValues[columnId] = DBTableLoader.decodeColumnFields(stream, columnTypes);
                    columnId = stream.readUnsignedByte();
                }
                def.setColumnTypes(types);
                def.setColumnValues(columnValues);
                break;
            }
            case 4: {
                def.setTableId(stream.readVarInt2());
                break;
            }
            default: {
                log.warn("Unrecognized dbrow opcode {}", (Object)opcode);
            }
        }
    }
}

