/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache.definitions;

import java.util.Arrays;

public class SpriteDefinition {
    private int id;
    private int frame;
    private int offsetX;
    private int offsetY;
    private int width;
    private int height;
    private int[] pixels;
    private int maxWidth;
    private int maxHeight;
    public transient byte[] pixelIdx;
    public transient int[] palette;

    public void normalize() {
        if (this.width != this.maxWidth || this.height != this.maxHeight) {
            byte[] var1 = new byte[this.maxWidth * this.maxHeight];
            int var2 = 0;
            for (int var3 = 0; var3 < this.height; ++var3) {
                for (int var4 = 0; var4 < this.width; ++var4) {
                    var1[var4 + (var3 + this.offsetY) * this.maxWidth + this.offsetX] = this.pixelIdx[var2++];
                }
            }
            this.pixelIdx = var1;
            this.width = this.maxWidth;
            this.height = this.maxHeight;
            this.offsetX = 0;
            this.offsetY = 0;
        }
    }

    public int getId() {
        return this.id;
    }

    public int getFrame() {
        return this.frame;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int[] getPixels() {
        return this.pixels;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public byte[] getPixelIdx() {
        return this.pixelIdx;
    }

    public int[] getPalette() {
        return this.palette;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setFrame(int frame) {
        this.frame = frame;
    }

    public void setOffsetX(int offsetX) {
        this.offsetX = offsetX;
    }

    public void setOffsetY(int offsetY) {
        this.offsetY = offsetY;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setPixels(int[] pixels) {
        this.pixels = pixels;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
    }

    public void setPixelIdx(byte[] pixelIdx) {
        this.pixelIdx = pixelIdx;
    }

    public void setPalette(int[] palette) {
        this.palette = palette;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpriteDefinition)) {
            return false;
        }
        SpriteDefinition other = (SpriteDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getFrame() != other.getFrame()) {
            return false;
        }
        if (this.getOffsetX() != other.getOffsetX()) {
            return false;
        }
        if (this.getOffsetY() != other.getOffsetY()) {
            return false;
        }
        if (this.getWidth() != other.getWidth()) {
            return false;
        }
        if (this.getHeight() != other.getHeight()) {
            return false;
        }
        if (this.getMaxWidth() != other.getMaxWidth()) {
            return false;
        }
        if (this.getMaxHeight() != other.getMaxHeight()) {
            return false;
        }
        return Arrays.equals(this.getPixels(), other.getPixels());
    }

    protected boolean canEqual(Object other) {
        return other instanceof SpriteDefinition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        result = result * 59 + this.getFrame();
        result = result * 59 + this.getOffsetX();
        result = result * 59 + this.getOffsetY();
        result = result * 59 + this.getWidth();
        result = result * 59 + this.getHeight();
        result = result * 59 + this.getMaxWidth();
        result = result * 59 + this.getMaxHeight();
        result = result * 59 + Arrays.hashCode(this.getPixels());
        return result;
    }

    public String toString() {
        return "SpriteDefinition(id=" + this.getId() + ", frame=" + this.getFrame() + ", offsetX=" + this.getOffsetX() + ", offsetY=" + this.getOffsetY() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", pixels=" + Arrays.toString(this.getPixels()) + ", maxWidth=" + this.getMaxWidth() + ", maxHeight=" + this.getMaxHeight() + ", pixelIdx=" + Arrays.toString(this.getPixelIdx()) + ", palette=" + Arrays.toString(this.getPalette()) + ")";
    }
}

