/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache.definitions;

public class OverlayDefinition {
    private int id;
    private int rgbColor = 0;
    private int texture = -1;
    private int secondaryRgbColor = -1;
    private boolean hideUnderlay = true;
    private transient int hue;
    private transient int saturation;
    private transient int lightness;
    private transient int otherHue;
    private transient int otherSaturation;
    private transient int otherLightness;

    public void calculateHsl() {
        if (this.secondaryRgbColor != -1) {
            this.calculateHsl(this.secondaryRgbColor);
            this.otherHue = this.hue;
            this.otherSaturation = this.saturation;
            this.otherLightness = this.lightness;
        }
        this.calculateHsl(this.rgbColor);
    }

    private void calculateHsl(int var1) {
        double var2 = (double)(var1 >> 16 & 0xFF) / 256.0;
        double var4 = (double)(var1 >> 8 & 0xFF) / 256.0;
        double var6 = (double)(var1 & 0xFF) / 256.0;
        double var8 = var2;
        if (var4 < var2) {
            var8 = var4;
        }
        if (var6 < var8) {
            var8 = var6;
        }
        double var10 = var2;
        if (var4 > var2) {
            var10 = var4;
        }
        if (var6 > var10) {
            var10 = var6;
        }
        double var12 = 0.0;
        double var14 = 0.0;
        double var16 = (var8 + var10) / 2.0;
        if (var10 != var8) {
            if (var16 < 0.5) {
                var14 = (var10 - var8) / (var10 + var8);
            }
            if (var16 >= 0.5) {
                var14 = (var10 - var8) / (2.0 - var10 - var8);
            }
            if (var2 == var10) {
                var12 = (var4 - var6) / (var10 - var8);
            } else if (var4 == var10) {
                var12 = 2.0 + (var6 - var2) / (var10 - var8);
            } else if (var10 == var6) {
                var12 = 4.0 + (var2 - var4) / (var10 - var8);
            }
        }
        this.hue = (int)(256.0 * (var12 /= 6.0));
        this.saturation = (int)(var14 * 256.0);
        this.lightness = (int)(var16 * 256.0);
        if (this.saturation < 0) {
            this.saturation = 0;
        } else if (this.saturation > 255) {
            this.saturation = 255;
        }
        if (this.lightness < 0) {
            this.lightness = 0;
        } else if (this.lightness > 255) {
            this.lightness = 255;
        }
    }

    public int getId() {
        return this.id;
    }

    public int getRgbColor() {
        return this.rgbColor;
    }

    public int getTexture() {
        return this.texture;
    }

    public int getSecondaryRgbColor() {
        return this.secondaryRgbColor;
    }

    public boolean isHideUnderlay() {
        return this.hideUnderlay;
    }

    public int getHue() {
        return this.hue;
    }

    public int getSaturation() {
        return this.saturation;
    }

    public int getLightness() {
        return this.lightness;
    }

    public int getOtherHue() {
        return this.otherHue;
    }

    public int getOtherSaturation() {
        return this.otherSaturation;
    }

    public int getOtherLightness() {
        return this.otherLightness;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setRgbColor(int rgbColor) {
        this.rgbColor = rgbColor;
    }

    public void setTexture(int texture) {
        this.texture = texture;
    }

    public void setSecondaryRgbColor(int secondaryRgbColor) {
        this.secondaryRgbColor = secondaryRgbColor;
    }

    public void setHideUnderlay(boolean hideUnderlay) {
        this.hideUnderlay = hideUnderlay;
    }

    public void setHue(int hue) {
        this.hue = hue;
    }

    public void setSaturation(int saturation) {
        this.saturation = saturation;
    }

    public void setLightness(int lightness) {
        this.lightness = lightness;
    }

    public void setOtherHue(int otherHue) {
        this.otherHue = otherHue;
    }

    public void setOtherSaturation(int otherSaturation) {
        this.otherSaturation = otherSaturation;
    }

    public void setOtherLightness(int otherLightness) {
        this.otherLightness = otherLightness;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OverlayDefinition)) {
            return false;
        }
        OverlayDefinition other = (OverlayDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getRgbColor() != other.getRgbColor()) {
            return false;
        }
        if (this.getTexture() != other.getTexture()) {
            return false;
        }
        if (this.getSecondaryRgbColor() != other.getSecondaryRgbColor()) {
            return false;
        }
        return this.isHideUnderlay() == other.isHideUnderlay();
    }

    protected boolean canEqual(Object other) {
        return other instanceof OverlayDefinition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        result = result * 59 + this.getRgbColor();
        result = result * 59 + this.getTexture();
        result = result * 59 + this.getSecondaryRgbColor();
        result = result * 59 + (this.isHideUnderlay() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "OverlayDefinition(id=" + this.getId() + ", rgbColor=" + this.getRgbColor() + ", texture=" + this.getTexture() + ", secondaryRgbColor=" + this.getSecondaryRgbColor() + ", hideUnderlay=" + this.isHideUnderlay() + ", hue=" + this.getHue() + ", saturation=" + this.getSaturation() + ", lightness=" + this.getLightness() + ", otherHue=" + this.getOtherHue() + ", otherSaturation=" + this.getOtherSaturation() + ", otherLightness=" + this.getOtherLightness() + ")";
    }
}

