/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache.definitions;

import java.util.Arrays;
import net.runelite.cache.models.CircularAngle;
import net.runelite.cache.models.FaceNormal;
import net.runelite.cache.models.VertexNormal;

public class ModelDefinition {
    public int id;
    public int vertexCount = 0;
    public int[] vertexX;
    public int[] vertexY;
    public int[] vertexZ;
    public transient VertexNormal[] vertexNormals;
    public int faceCount;
    public int[] faceIndices1;
    public int[] faceIndices2;
    public int[] faceIndices3;
    public byte[] faceTransparencies;
    public short[] faceColors;
    public byte[] faceRenderPriorities;
    public byte[] faceRenderTypes;
    public transient FaceNormal[] faceNormals;
    public int numTextureFaces;
    public short[] texIndices1;
    public short[] texIndices2;
    public short[] texIndices3;
    public transient float[][] faceTextureUCoordinates;
    public transient float[][] faceTextureVCoordinates;
    public short[] texturePrimaryColors;
    public short[] faceTextures;
    public byte[] faceZOffsets;
    public byte[] textureCoords;
    public byte[] textureRenderTypes;
    public int[] packedVertexGroups;
    public int[] packedTransparencyVertexGroups;
    public byte priority;
    private transient int[][] vertexGroups;
    public int[][] animayaGroups;
    public int[][] animayaScales;
    private transient int[] origVX;
    private transient int[] origVY;
    private transient int[] origVZ;
    public transient int maxPriority;
    public static transient int animOffsetX;
    public static transient int animOffsetY;
    public static transient int animOffsetZ;

    public void computeNormals() {
        int var1;
        if (this.vertexNormals != null) {
            return;
        }
        this.vertexNormals = new VertexNormal[this.vertexCount];
        for (var1 = 0; var1 < this.vertexCount; ++var1) {
            this.vertexNormals[var1] = new VertexNormal();
        }
        for (var1 = 0; var1 < this.faceCount; ++var1) {
            int var13;
            int vertexA = this.faceIndices1[var1];
            int vertexB = this.faceIndices2[var1];
            int vertexC = this.faceIndices3[var1];
            int xA = this.vertexX[vertexB] - this.vertexX[vertexA];
            int yA = this.vertexY[vertexB] - this.vertexY[vertexA];
            int zA = this.vertexZ[vertexB] - this.vertexZ[vertexA];
            int xB = this.vertexX[vertexC] - this.vertexX[vertexA];
            int yB = this.vertexY[vertexC] - this.vertexY[vertexA];
            int zB = this.vertexZ[vertexC] - this.vertexZ[vertexA];
            int var11 = yA * zB - yB * zA;
            int var12 = zA * xB - zB * xA;
            for (var13 = xA * yB - xB * yA; var11 > 8192 || var12 > 8192 || var13 > 8192 || var11 < -8192 || var12 < -8192 || var13 < -8192; var11 >>= 1, var12 >>= 1, var13 >>= 1) {
            }
            int length = (int)Math.sqrt(var11 * var11 + var12 * var12 + var13 * var13);
            if (length <= 0) {
                length = 1;
            }
            var11 = var11 * 256 / length;
            var12 = var12 * 256 / length;
            var13 = var13 * 256 / length;
            byte var15 = this.faceRenderTypes == null ? (byte)0 : this.faceRenderTypes[var1];
            if (var15 == 0) {
                VertexNormal var16 = this.vertexNormals[vertexA];
                var16.x += var11;
                var16.y += var12;
                var16.z += var13;
                ++var16.magnitude;
                var16 = this.vertexNormals[vertexB];
                var16.x += var11;
                var16.y += var12;
                var16.z += var13;
                ++var16.magnitude;
                var16 = this.vertexNormals[vertexC];
                var16.x += var11;
                var16.y += var12;
                var16.z += var13;
                ++var16.magnitude;
                continue;
            }
            if (var15 != 1) continue;
            if (this.faceNormals == null) {
                this.faceNormals = new FaceNormal[this.faceCount];
            }
            FaceNormal var17 = this.faceNormals[var1] = new FaceNormal();
            var17.x = var11;
            var17.y = var12;
            var17.z = var13;
        }
    }

    public void computeTextureUVCoordinates() {
        this.faceTextureUCoordinates = new float[this.faceCount][];
        this.faceTextureVCoordinates = new float[this.faceCount][];
        if (this.faceTextures == null) {
            return;
        }
        for (int i = 0; i < this.faceCount; ++i) {
            float v2;
            float v1;
            float v0;
            float u2;
            float u1;
            float u0;
            if (this.faceTextures[i] == -1) continue;
            if (this.textureCoords != null && this.textureCoords[i] != -1) {
                int tfaceIdx = this.textureCoords[i] & 0xFF;
                int triangleA = this.faceIndices1[i];
                int triangleB = this.faceIndices2[i];
                int triangleC = this.faceIndices3[i];
                short texA = this.texIndices1[tfaceIdx];
                short texB = this.texIndices2[tfaceIdx];
                short texC = this.texIndices3[tfaceIdx];
                float v1x = this.vertexX[texA];
                float v1y = this.vertexY[texA];
                float v1z = this.vertexZ[texA];
                float v2x = (float)this.vertexX[texB] - v1x;
                float v2y = (float)this.vertexY[texB] - v1y;
                float v2z = (float)this.vertexZ[texB] - v1z;
                float v3x = (float)this.vertexX[texC] - v1x;
                float v3y = (float)this.vertexY[texC] - v1y;
                float v3z = (float)this.vertexZ[texC] - v1z;
                float v4x = (float)this.vertexX[triangleA] - v1x;
                float v4y = (float)this.vertexY[triangleA] - v1y;
                float v4z = (float)this.vertexZ[triangleA] - v1z;
                float v5x = (float)this.vertexX[triangleB] - v1x;
                float v5y = (float)this.vertexY[triangleB] - v1y;
                float v5z = (float)this.vertexZ[triangleB] - v1z;
                float v6x = (float)this.vertexX[triangleC] - v1x;
                float v6y = (float)this.vertexY[triangleC] - v1y;
                float v6z = (float)this.vertexZ[triangleC] - v1z;
                float v7x = v2y * v3z - v2z * v3y;
                float v7y = v2z * v3x - v2x * v3z;
                float v7z = v2x * v3y - v2y * v3x;
                float v8x = v3y * v7z - v3z * v7y;
                float v8y = v3z * v7x - v3x * v7z;
                float v8z = v3x * v7y - v3y * v7x;
                float f = 1.0f / (v8x * v2x + v8y * v2y + v8z * v2z);
                u0 = (v8x * v4x + v8y * v4y + v8z * v4z) * f;
                u1 = (v8x * v5x + v8y * v5y + v8z * v5z) * f;
                u2 = (v8x * v6x + v8y * v6y + v8z * v6z) * f;
                v8x = v2y * v7z - v2z * v7y;
                v8y = v2z * v7x - v2x * v7z;
                v8z = v2x * v7y - v2y * v7x;
                f = 1.0f / (v8x * v3x + v8y * v3y + v8z * v3z);
                v0 = (v8x * v4x + v8y * v4y + v8z * v4z) * f;
                v1 = (v8x * v5x + v8y * v5y + v8z * v5z) * f;
                v2 = (v8x * v6x + v8y * v6y + v8z * v6z) * f;
            } else {
                u0 = 0.0f;
                v0 = 0.0f;
                u1 = 1.0f;
                v1 = 0.0f;
                u2 = 0.0f;
                v2 = 1.0f;
            }
            this.faceTextureUCoordinates[i] = new float[]{u0, u1, u2};
            this.faceTextureVCoordinates[i] = new float[]{v0, v1, v2};
        }
    }

    public void computeAnimationTables() {
        if (this.packedVertexGroups != null) {
            int var4;
            int var3;
            int[] groupCounts = new int[256];
            int numGroups = 0;
            for (var3 = 0; var3 < this.vertexCount; ++var3) {
                int n = var4 = this.packedVertexGroups[var3];
                groupCounts[n] = groupCounts[n] + 1;
                if (var4 <= numGroups) continue;
                numGroups = var4;
            }
            this.vertexGroups = new int[numGroups + 1][];
            for (var3 = 0; var3 <= numGroups; ++var3) {
                this.vertexGroups[var3] = new int[groupCounts[var3]];
                groupCounts[var3] = 0;
            }
            var3 = 0;
            while (var3 < this.vertexCount) {
                int n = var4 = this.packedVertexGroups[var3];
                int n2 = groupCounts[n];
                groupCounts[n] = n2 + 1;
                this.vertexGroups[var4][n2] = var3++;
            }
            this.packedVertexGroups = null;
        }
    }

    public void rotate(int orientation) {
        int sin = CircularAngle.SINE[orientation];
        int cos = CircularAngle.COSINE[orientation];
        assert (this.vertexX.length == this.vertexY.length);
        assert (this.vertexY.length == this.vertexZ.length);
        for (int i = 0; i < this.vertexX.length; ++i) {
            this.vertexX[i] = this.vertexX[i] * cos + this.vertexZ[i] * sin >> 16;
            this.vertexZ[i] = this.vertexZ[i] * cos - this.vertexX[i] * sin >> 16;
        }
        this.reset();
    }

    public void resetAnim() {
        if (this.origVX == null) {
            return;
        }
        System.arraycopy(this.origVX, 0, this.vertexX, 0, this.origVX.length);
        System.arraycopy(this.origVY, 0, this.vertexY, 0, this.origVY.length);
        System.arraycopy(this.origVZ, 0, this.vertexZ, 0, this.origVZ.length);
    }

    public void animate(int type, int[] frameMap, int dx, int dy, int dz) {
        if (this.origVX == null) {
            this.origVX = Arrays.copyOf(this.vertexX, this.vertexX.length);
            this.origVY = Arrays.copyOf(this.vertexY, this.vertexY.length);
            this.origVZ = Arrays.copyOf(this.vertexZ, this.vertexZ.length);
        }
        int[] verticesX = this.vertexX;
        int[] verticesY = this.vertexY;
        int[] verticesZ = this.vertexZ;
        int var6 = frameMap.length;
        if (type == 0) {
            int var7 = 0;
            animOffsetX = 0;
            animOffsetY = 0;
            animOffsetZ = 0;
            for (int var8 = 0; var8 < var6; ++var8) {
                int var9 = frameMap[var8];
                if (var9 >= this.vertexGroups.length) continue;
                int[] var10 = this.vertexGroups[var9];
                for (int var11 = 0; var11 < var10.length; ++var11) {
                    int var12 = var10[var11];
                    animOffsetX += verticesX[var12];
                    animOffsetY += verticesY[var12];
                    animOffsetZ += verticesZ[var12];
                    ++var7;
                }
            }
            if (var7 > 0) {
                animOffsetX = dx + animOffsetX / var7;
                animOffsetY = dy + animOffsetY / var7;
                animOffsetZ = dz + animOffsetZ / var7;
            } else {
                animOffsetX = dx;
                animOffsetY = dy;
                animOffsetZ = dz;
            }
        } else if (type == 1) {
            for (int var7 = 0; var7 < var6; ++var7) {
                int var8 = frameMap[var7];
                if (var8 >= this.vertexGroups.length) continue;
                int[] var18 = this.vertexGroups[var8];
                for (int var19 = 0; var19 < var18.length; ++var19) {
                    int var11;
                    int n = var11 = var18[var19];
                    verticesX[n] = verticesX[n] + dx;
                    int n2 = var11;
                    verticesY[n2] = verticesY[n2] + dy;
                    int n3 = var11;
                    verticesZ[n3] = verticesZ[n3] + dz;
                }
            }
        } else if (type == 2) {
            for (int var7 = 0; var7 < var6; ++var7) {
                int var8 = frameMap[var7];
                if (var8 >= this.vertexGroups.length) continue;
                int[] var18 = this.vertexGroups[var8];
                for (int var19 = 0; var19 < var18.length; ++var19) {
                    int var17;
                    int var16;
                    int var15;
                    int var11;
                    int n = var11 = var18[var19];
                    verticesX[n] = verticesX[n] - animOffsetX;
                    int n4 = var11;
                    verticesY[n4] = verticesY[n4] - animOffsetY;
                    int n5 = var11;
                    verticesZ[n5] = verticesZ[n5] - animOffsetZ;
                    int var12 = (dx & 0xFF) * 8;
                    int var13 = (dy & 0xFF) * 8;
                    int var14 = (dz & 0xFF) * 8;
                    if (var14 != 0) {
                        var15 = CircularAngle.SINE[var14];
                        var16 = CircularAngle.COSINE[var14];
                        var17 = var15 * verticesY[var11] + var16 * verticesX[var11] >> 16;
                        verticesY[var11] = var16 * verticesY[var11] - var15 * verticesX[var11] >> 16;
                        verticesX[var11] = var17;
                    }
                    if (var12 != 0) {
                        var15 = CircularAngle.SINE[var12];
                        var16 = CircularAngle.COSINE[var12];
                        var17 = var16 * verticesY[var11] - var15 * verticesZ[var11] >> 16;
                        verticesZ[var11] = var15 * verticesY[var11] + var16 * verticesZ[var11] >> 16;
                        verticesY[var11] = var17;
                    }
                    if (var13 != 0) {
                        var15 = CircularAngle.SINE[var13];
                        var16 = CircularAngle.COSINE[var13];
                        var17 = var15 * verticesZ[var11] + var16 * verticesX[var11] >> 16;
                        verticesZ[var11] = var16 * verticesZ[var11] - var15 * verticesX[var11] >> 16;
                        verticesX[var11] = var17;
                    }
                    int n6 = var11;
                    verticesX[n6] = verticesX[n6] + animOffsetX;
                    int n7 = var11;
                    verticesY[n7] = verticesY[n7] + animOffsetY;
                    int n8 = var11;
                    verticesZ[n8] = verticesZ[n8] + animOffsetZ;
                }
            }
        } else if (type == 3) {
            for (int var7 = 0; var7 < var6; ++var7) {
                int var8 = frameMap[var7];
                if (var8 >= this.vertexGroups.length) continue;
                int[] var18 = this.vertexGroups[var8];
                for (int var19 = 0; var19 < var18.length; ++var19) {
                    int var11;
                    int n = var11 = var18[var19];
                    verticesX[n] = verticesX[n] - animOffsetX;
                    int n9 = var11;
                    verticesY[n9] = verticesY[n9] - animOffsetY;
                    int n10 = var11;
                    verticesZ[n10] = verticesZ[n10] - animOffsetZ;
                    verticesX[var11] = dx * verticesX[var11] / 128;
                    verticesY[var11] = dy * verticesY[var11] / 128;
                    verticesZ[var11] = dz * verticesZ[var11] / 128;
                    int n11 = var11;
                    verticesX[n11] = verticesX[n11] + animOffsetX;
                    int n12 = var11;
                    verticesY[n12] = verticesY[n12] + animOffsetY;
                    int n13 = var11;
                    verticesZ[n13] = verticesZ[n13] + animOffsetZ;
                }
            }
        } else if (type == 5) {
            // empty if block
        }
    }

    public void method1493() {
        int var1;
        for (var1 = 0; var1 < this.vertexCount; ++var1) {
            this.vertexZ[var1] = -this.vertexZ[var1];
        }
        for (var1 = 0; var1 < this.faceCount; ++var1) {
            int var2 = this.faceIndices1[var1];
            this.faceIndices1[var1] = this.faceIndices3[var1];
            this.faceIndices3[var1] = var2;
        }
        this.reset();
    }

    public void rotate1() {
        for (int var1 = 0; var1 < this.vertexCount; ++var1) {
            int var2 = this.vertexX[var1];
            this.vertexX[var1] = this.vertexZ[var1];
            this.vertexZ[var1] = -var2;
        }
        this.reset();
    }

    public void rotate2() {
        for (int var1 = 0; var1 < this.vertexCount; ++var1) {
            this.vertexX[var1] = -this.vertexX[var1];
            this.vertexZ[var1] = -this.vertexZ[var1];
        }
        this.reset();
    }

    public void rotate3() {
        for (int var1 = 0; var1 < this.vertexCount; ++var1) {
            int var2 = this.vertexZ[var1];
            this.vertexZ[var1] = this.vertexX[var1];
            this.vertexX[var1] = -var2;
        }
        this.reset();
    }

    private void reset() {
        this.vertexNormals = null;
        this.faceNormals = null;
        this.faceTextureVCoordinates = null;
        this.faceTextureUCoordinates = null;
    }

    public void resize(int var1, int var2, int var3) {
        for (int var4 = 0; var4 < this.vertexCount; ++var4) {
            this.vertexX[var4] = this.vertexX[var4] * var1 / 128;
            this.vertexY[var4] = var2 * this.vertexY[var4] / 128;
            this.vertexZ[var4] = var3 * this.vertexZ[var4] / 128;
        }
        this.reset();
    }

    public void recolor(short var1, short var2) {
        for (int var3 = 0; var3 < this.faceCount; ++var3) {
            if (this.faceColors[var3] != var1) continue;
            this.faceColors[var3] = var2;
        }
    }

    public void retexture(short var1, short var2) {
        if (this.faceTextures != null) {
            for (int var3 = 0; var3 < this.faceCount; ++var3) {
                if (this.faceTextures[var3] != var1) continue;
                this.faceTextures[var3] = var2;
            }
        }
    }

    public void move(int xOffset, int yOffset, int zOffset) {
        int i = 0;
        while (i < this.vertexCount) {
            int n = i;
            this.vertexX[n] = this.vertexX[n] + xOffset;
            int n2 = i;
            this.vertexY[n2] = this.vertexY[n2] + yOffset;
            int n3 = i++;
            this.vertexZ[n3] = this.vertexZ[n3] + zOffset;
        }
        this.reset();
    }

    public void computeMaxPriority() {
        if (this.faceRenderPriorities == null) {
            return;
        }
        for (int i = 0; i < this.faceCount; ++i) {
            if (this.faceRenderPriorities[i] <= this.maxPriority) continue;
            this.maxPriority = this.faceRenderPriorities[i];
        }
    }

    public int getId() {
        return this.id;
    }

    public int getVertexCount() {
        return this.vertexCount;
    }

    public int[] getVertexX() {
        return this.vertexX;
    }

    public int[] getVertexY() {
        return this.vertexY;
    }

    public int[] getVertexZ() {
        return this.vertexZ;
    }

    public VertexNormal[] getVertexNormals() {
        return this.vertexNormals;
    }

    public int getFaceCount() {
        return this.faceCount;
    }

    public int[] getFaceIndices1() {
        return this.faceIndices1;
    }

    public int[] getFaceIndices2() {
        return this.faceIndices2;
    }

    public int[] getFaceIndices3() {
        return this.faceIndices3;
    }

    public byte[] getFaceTransparencies() {
        return this.faceTransparencies;
    }

    public short[] getFaceColors() {
        return this.faceColors;
    }

    public byte[] getFaceRenderPriorities() {
        return this.faceRenderPriorities;
    }

    public byte[] getFaceRenderTypes() {
        return this.faceRenderTypes;
    }

    public FaceNormal[] getFaceNormals() {
        return this.faceNormals;
    }

    public int getNumTextureFaces() {
        return this.numTextureFaces;
    }

    public short[] getTexIndices1() {
        return this.texIndices1;
    }

    public short[] getTexIndices2() {
        return this.texIndices2;
    }

    public short[] getTexIndices3() {
        return this.texIndices3;
    }

    public float[][] getFaceTextureUCoordinates() {
        return this.faceTextureUCoordinates;
    }

    public float[][] getFaceTextureVCoordinates() {
        return this.faceTextureVCoordinates;
    }

    public short[] getTexturePrimaryColors() {
        return this.texturePrimaryColors;
    }

    public short[] getFaceTextures() {
        return this.faceTextures;
    }

    public byte[] getFaceZOffsets() {
        return this.faceZOffsets;
    }

    public byte[] getTextureCoords() {
        return this.textureCoords;
    }

    public byte[] getTextureRenderTypes() {
        return this.textureRenderTypes;
    }

    public int[] getPackedVertexGroups() {
        return this.packedVertexGroups;
    }

    public int[] getPackedTransparencyVertexGroups() {
        return this.packedTransparencyVertexGroups;
    }

    public byte getPriority() {
        return this.priority;
    }

    public int[][] getVertexGroups() {
        return this.vertexGroups;
    }

    public int[][] getAnimayaGroups() {
        return this.animayaGroups;
    }

    public int[][] getAnimayaScales() {
        return this.animayaScales;
    }

    public int[] getOrigVX() {
        return this.origVX;
    }

    public int[] getOrigVY() {
        return this.origVY;
    }

    public int[] getOrigVZ() {
        return this.origVZ;
    }

    public int getMaxPriority() {
        return this.maxPriority;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setVertexCount(int vertexCount) {
        this.vertexCount = vertexCount;
    }

    public void setVertexX(int[] vertexX) {
        this.vertexX = vertexX;
    }

    public void setVertexY(int[] vertexY) {
        this.vertexY = vertexY;
    }

    public void setVertexZ(int[] vertexZ) {
        this.vertexZ = vertexZ;
    }

    public void setVertexNormals(VertexNormal[] vertexNormals) {
        this.vertexNormals = vertexNormals;
    }

    public void setFaceCount(int faceCount) {
        this.faceCount = faceCount;
    }

    public void setFaceIndices1(int[] faceIndices1) {
        this.faceIndices1 = faceIndices1;
    }

    public void setFaceIndices2(int[] faceIndices2) {
        this.faceIndices2 = faceIndices2;
    }

    public void setFaceIndices3(int[] faceIndices3) {
        this.faceIndices3 = faceIndices3;
    }

    public void setFaceTransparencies(byte[] faceTransparencies) {
        this.faceTransparencies = faceTransparencies;
    }

    public void setFaceColors(short[] faceColors) {
        this.faceColors = faceColors;
    }

    public void setFaceRenderPriorities(byte[] faceRenderPriorities) {
        this.faceRenderPriorities = faceRenderPriorities;
    }

    public void setFaceRenderTypes(byte[] faceRenderTypes) {
        this.faceRenderTypes = faceRenderTypes;
    }

    public void setFaceNormals(FaceNormal[] faceNormals) {
        this.faceNormals = faceNormals;
    }

    public void setNumTextureFaces(int numTextureFaces) {
        this.numTextureFaces = numTextureFaces;
    }

    public void setTexIndices1(short[] texIndices1) {
        this.texIndices1 = texIndices1;
    }

    public void setTexIndices2(short[] texIndices2) {
        this.texIndices2 = texIndices2;
    }

    public void setTexIndices3(short[] texIndices3) {
        this.texIndices3 = texIndices3;
    }

    public void setFaceTextureUCoordinates(float[][] faceTextureUCoordinates) {
        this.faceTextureUCoordinates = faceTextureUCoordinates;
    }

    public void setFaceTextureVCoordinates(float[][] faceTextureVCoordinates) {
        this.faceTextureVCoordinates = faceTextureVCoordinates;
    }

    public void setTexturePrimaryColors(short[] texturePrimaryColors) {
        this.texturePrimaryColors = texturePrimaryColors;
    }

    public void setFaceTextures(short[] faceTextures) {
        this.faceTextures = faceTextures;
    }

    public void setFaceZOffsets(byte[] faceZOffsets) {
        this.faceZOffsets = faceZOffsets;
    }

    public void setTextureCoords(byte[] textureCoords) {
        this.textureCoords = textureCoords;
    }

    public void setTextureRenderTypes(byte[] textureRenderTypes) {
        this.textureRenderTypes = textureRenderTypes;
    }

    public void setPackedVertexGroups(int[] packedVertexGroups) {
        this.packedVertexGroups = packedVertexGroups;
    }

    public void setPackedTransparencyVertexGroups(int[] packedTransparencyVertexGroups) {
        this.packedTransparencyVertexGroups = packedTransparencyVertexGroups;
    }

    public void setPriority(byte priority) {
        this.priority = priority;
    }

    public void setVertexGroups(int[][] vertexGroups) {
        this.vertexGroups = vertexGroups;
    }

    public void setAnimayaGroups(int[][] animayaGroups) {
        this.animayaGroups = animayaGroups;
    }

    public void setAnimayaScales(int[][] animayaScales) {
        this.animayaScales = animayaScales;
    }

    public void setOrigVX(int[] origVX) {
        this.origVX = origVX;
    }

    public void setOrigVY(int[] origVY) {
        this.origVY = origVY;
    }

    public void setOrigVZ(int[] origVZ) {
        this.origVZ = origVZ;
    }

    public void setMaxPriority(int maxPriority) {
        this.maxPriority = maxPriority;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModelDefinition)) {
            return false;
        }
        ModelDefinition other = (ModelDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getVertexCount() != other.getVertexCount()) {
            return false;
        }
        if (this.getFaceCount() != other.getFaceCount()) {
            return false;
        }
        if (this.getNumTextureFaces() != other.getNumTextureFaces()) {
            return false;
        }
        if (this.getPriority() != other.getPriority()) {
            return false;
        }
        if (!Arrays.equals(this.getVertexX(), other.getVertexX())) {
            return false;
        }
        if (!Arrays.equals(this.getVertexY(), other.getVertexY())) {
            return false;
        }
        if (!Arrays.equals(this.getVertexZ(), other.getVertexZ())) {
            return false;
        }
        if (!Arrays.equals(this.getFaceIndices1(), other.getFaceIndices1())) {
            return false;
        }
        if (!Arrays.equals(this.getFaceIndices2(), other.getFaceIndices2())) {
            return false;
        }
        if (!Arrays.equals(this.getFaceIndices3(), other.getFaceIndices3())) {
            return false;
        }
        if (!Arrays.equals(this.getFaceTransparencies(), other.getFaceTransparencies())) {
            return false;
        }
        if (!Arrays.equals(this.getFaceColors(), other.getFaceColors())) {
            return false;
        }
        if (!Arrays.equals(this.getFaceRenderPriorities(), other.getFaceRenderPriorities())) {
            return false;
        }
        if (!Arrays.equals(this.getFaceRenderTypes(), other.getFaceRenderTypes())) {
            return false;
        }
        if (!Arrays.equals(this.getTexIndices1(), other.getTexIndices1())) {
            return false;
        }
        if (!Arrays.equals(this.getTexIndices2(), other.getTexIndices2())) {
            return false;
        }
        if (!Arrays.equals(this.getTexIndices3(), other.getTexIndices3())) {
            return false;
        }
        if (!Arrays.equals(this.getTexturePrimaryColors(), other.getTexturePrimaryColors())) {
            return false;
        }
        if (!Arrays.equals(this.getFaceTextures(), other.getFaceTextures())) {
            return false;
        }
        if (!Arrays.equals(this.getFaceZOffsets(), other.getFaceZOffsets())) {
            return false;
        }
        if (!Arrays.equals(this.getTextureCoords(), other.getTextureCoords())) {
            return false;
        }
        if (!Arrays.equals(this.getTextureRenderTypes(), other.getTextureRenderTypes())) {
            return false;
        }
        if (!Arrays.equals(this.getPackedVertexGroups(), other.getPackedVertexGroups())) {
            return false;
        }
        if (!Arrays.equals(this.getPackedTransparencyVertexGroups(), other.getPackedTransparencyVertexGroups())) {
            return false;
        }
        if (!Arrays.deepEquals((Object[])this.getAnimayaGroups(), (Object[])other.getAnimayaGroups())) {
            return false;
        }
        return Arrays.deepEquals((Object[])this.getAnimayaScales(), (Object[])other.getAnimayaScales());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModelDefinition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        result = result * 59 + this.getVertexCount();
        result = result * 59 + this.getFaceCount();
        result = result * 59 + this.getNumTextureFaces();
        result = result * 59 + this.getPriority();
        result = result * 59 + Arrays.hashCode(this.getVertexX());
        result = result * 59 + Arrays.hashCode(this.getVertexY());
        result = result * 59 + Arrays.hashCode(this.getVertexZ());
        result = result * 59 + Arrays.hashCode(this.getFaceIndices1());
        result = result * 59 + Arrays.hashCode(this.getFaceIndices2());
        result = result * 59 + Arrays.hashCode(this.getFaceIndices3());
        result = result * 59 + Arrays.hashCode(this.getFaceTransparencies());
        result = result * 59 + Arrays.hashCode(this.getFaceColors());
        result = result * 59 + Arrays.hashCode(this.getFaceRenderPriorities());
        result = result * 59 + Arrays.hashCode(this.getFaceRenderTypes());
        result = result * 59 + Arrays.hashCode(this.getTexIndices1());
        result = result * 59 + Arrays.hashCode(this.getTexIndices2());
        result = result * 59 + Arrays.hashCode(this.getTexIndices3());
        result = result * 59 + Arrays.hashCode(this.getTexturePrimaryColors());
        result = result * 59 + Arrays.hashCode(this.getFaceTextures());
        result = result * 59 + Arrays.hashCode(this.getFaceZOffsets());
        result = result * 59 + Arrays.hashCode(this.getTextureCoords());
        result = result * 59 + Arrays.hashCode(this.getTextureRenderTypes());
        result = result * 59 + Arrays.hashCode(this.getPackedVertexGroups());
        result = result * 59 + Arrays.hashCode(this.getPackedTransparencyVertexGroups());
        result = result * 59 + Arrays.deepHashCode((Object[])this.getAnimayaGroups());
        result = result * 59 + Arrays.deepHashCode((Object[])this.getAnimayaScales());
        return result;
    }

    public String toString() {
        return "ModelDefinition(id=" + this.getId() + ", vertexCount=" + this.getVertexCount() + ", vertexX=" + Arrays.toString(this.getVertexX()) + ", vertexY=" + Arrays.toString(this.getVertexY()) + ", vertexZ=" + Arrays.toString(this.getVertexZ()) + ", vertexNormals=" + Arrays.deepToString(this.getVertexNormals()) + ", faceCount=" + this.getFaceCount() + ", faceIndices1=" + Arrays.toString(this.getFaceIndices1()) + ", faceIndices2=" + Arrays.toString(this.getFaceIndices2()) + ", faceIndices3=" + Arrays.toString(this.getFaceIndices3()) + ", faceTransparencies=" + Arrays.toString(this.getFaceTransparencies()) + ", faceColors=" + Arrays.toString(this.getFaceColors()) + ", faceRenderPriorities=" + Arrays.toString(this.getFaceRenderPriorities()) + ", faceRenderTypes=" + Arrays.toString(this.getFaceRenderTypes()) + ", faceNormals=" + Arrays.deepToString(this.getFaceNormals()) + ", numTextureFaces=" + this.getNumTextureFaces() + ", texIndices1=" + Arrays.toString(this.getTexIndices1()) + ", texIndices2=" + Arrays.toString(this.getTexIndices2()) + ", texIndices3=" + Arrays.toString(this.getTexIndices3()) + ", faceTextureUCoordinates=" + Arrays.deepToString((Object[])this.getFaceTextureUCoordinates()) + ", faceTextureVCoordinates=" + Arrays.deepToString((Object[])this.getFaceTextureVCoordinates()) + ", texturePrimaryColors=" + Arrays.toString(this.getTexturePrimaryColors()) + ", faceTextures=" + Arrays.toString(this.getFaceTextures()) + ", faceZOffsets=" + Arrays.toString(this.getFaceZOffsets()) + ", textureCoords=" + Arrays.toString(this.getTextureCoords()) + ", textureRenderTypes=" + Arrays.toString(this.getTextureRenderTypes()) + ", packedVertexGroups=" + Arrays.toString(this.getPackedVertexGroups()) + ", packedTransparencyVertexGroups=" + Arrays.toString(this.getPackedTransparencyVertexGroups()) + ", priority=" + this.getPriority() + ", vertexGroups=" + Arrays.deepToString((Object[])this.getVertexGroups()) + ", animayaGroups=" + Arrays.deepToString((Object[])this.getAnimayaGroups()) + ", animayaScales=" + Arrays.deepToString((Object[])this.getAnimayaScales()) + ", origVX=" + Arrays.toString(this.getOrigVX()) + ", origVY=" + Arrays.toString(this.getOrigVY()) + ", origVZ=" + Arrays.toString(this.getOrigVZ()) + ", maxPriority=" + this.getMaxPriority() + ")";
    }
}

