/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.runelite.cache.ConfigType;
import net.runelite.cache.IndexType;
import net.runelite.cache.definitions.UnderlayDefinition;
import net.runelite.cache.definitions.loaders.UnderlayLoader;
import net.runelite.cache.definitions.providers.UnderlayProvider;
import net.runelite.cache.fs.Archive;
import net.runelite.cache.fs.ArchiveFiles;
import net.runelite.cache.fs.FSFile;
import net.runelite.cache.fs.Index;
import net.runelite.cache.fs.Storage;
import net.runelite.cache.fs.Store;

public class UnderlayManager
implements UnderlayProvider {
    private final Store store;
    private final Map<Integer, UnderlayDefinition> underlays = new HashMap<Integer, UnderlayDefinition>();

    public UnderlayManager(Store store) {
        this.store = store;
    }

    public void load() throws IOException {
        Storage storage = this.store.getStorage();
        Index index = this.store.getIndex(IndexType.CONFIGS);
        Archive archive = index.getArchive(ConfigType.UNDERLAY.getId());
        byte[] archiveData = storage.loadArchive(archive);
        ArchiveFiles files = archive.getFiles(archiveData);
        for (FSFile file : files.getFiles()) {
            UnderlayLoader loader = new UnderlayLoader();
            UnderlayDefinition underlay = loader.load(file.getFileId(), file.getContents());
            this.underlays.put(underlay.getId(), underlay);
        }
    }

    public Collection<UnderlayDefinition> getUnderlays() {
        return Collections.unmodifiableCollection(this.underlays.values());
    }

    @Override
    public UnderlayDefinition provide(int underlayId) {
        return this.underlays.get(underlayId);
    }
}

