/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.runelite.cache.IndexType;
import net.runelite.cache.definitions.TextureDefinition;
import net.runelite.cache.definitions.loaders.TextureLoader;
import net.runelite.cache.definitions.providers.TextureProvider;
import net.runelite.cache.fs.Archive;
import net.runelite.cache.fs.ArchiveFiles;
import net.runelite.cache.fs.FSFile;
import net.runelite.cache.fs.Index;
import net.runelite.cache.fs.Storage;
import net.runelite.cache.fs.Store;

public class TextureManager
implements TextureProvider {
    private final Store store;
    private final List<TextureDefinition> textures = new ArrayList<TextureDefinition>();

    public TextureManager(Store store) {
        this.store = store;
    }

    public void load() throws IOException {
        Storage storage = this.store.getStorage();
        Index index = this.store.getIndex(IndexType.TEXTURES);
        Archive archive = index.getArchive(0);
        byte[] archiveData = storage.loadArchive(archive);
        ArchiveFiles files = archive.getFiles(archiveData);
        TextureLoader loader = new TextureLoader();
        for (FSFile file : files.getFiles()) {
            TextureDefinition texture = loader.load(file.getFileId(), file.getContents());
            this.textures.add(texture);
        }
    }

    public List<TextureDefinition> getTextures() {
        return this.textures;
    }

    public TextureDefinition findTexture(int id) {
        for (TextureDefinition td : this.textures) {
            if (td.getId() != id) continue;
            return td;
        }
        return null;
    }

    @Override
    public TextureDefinition[] provide() {
        return this.textures.toArray(new TextureDefinition[this.textures.size()]);
    }
}

