/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.runelite.cache.ConfigType;
import net.runelite.cache.IndexType;
import net.runelite.cache.definitions.OverlayDefinition;
import net.runelite.cache.definitions.loaders.OverlayLoader;
import net.runelite.cache.definitions.providers.OverlayProvider;
import net.runelite.cache.fs.Archive;
import net.runelite.cache.fs.ArchiveFiles;
import net.runelite.cache.fs.FSFile;
import net.runelite.cache.fs.Index;
import net.runelite.cache.fs.Storage;
import net.runelite.cache.fs.Store;

public class OverlayManager
implements OverlayProvider {
    private final Store store;
    private final Map<Integer, OverlayDefinition> overlays = new HashMap<Integer, OverlayDefinition>();

    public OverlayManager(Store store) {
        this.store = store;
    }

    public void load() throws IOException {
        Storage storage = this.store.getStorage();
        Index index = this.store.getIndex(IndexType.CONFIGS);
        Archive archive = index.getArchive(ConfigType.OVERLAY.getId());
        byte[] archiveData = storage.loadArchive(archive);
        ArchiveFiles files = archive.getFiles(archiveData);
        for (FSFile file : files.getFiles()) {
            OverlayLoader loader = new OverlayLoader();
            OverlayDefinition overlay = loader.load(file.getFileId(), file.getContents());
            this.overlays.put(overlay.getId(), overlay);
        }
    }

    public Collection<OverlayDefinition> getOverlays() {
        return Collections.unmodifiableCollection(this.overlays.values());
    }

    @Override
    public OverlayDefinition provide(int overlayId) {
        return this.overlays.get(overlayId);
    }
}

