/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.runelite.cache.ConfigType;
import net.runelite.cache.IndexType;
import net.runelite.cache.definitions.ObjectDefinition;
import net.runelite.cache.definitions.exporters.ObjectExporter;
import net.runelite.cache.definitions.loaders.ObjectLoader;
import net.runelite.cache.fs.Archive;
import net.runelite.cache.fs.ArchiveFiles;
import net.runelite.cache.fs.FSFile;
import net.runelite.cache.fs.Index;
import net.runelite.cache.fs.Storage;
import net.runelite.cache.fs.Store;
import net.runelite.cache.util.IDClass;

public class ObjectManager {
    private final Store store;
    private final Map<Integer, ObjectDefinition> objects = new HashMap<Integer, ObjectDefinition>();

    public ObjectManager(Store store) {
        this.store = store;
    }

    public void load() throws IOException {
        ObjectLoader loader = new ObjectLoader();
        Storage storage = this.store.getStorage();
        Index index = this.store.getIndex(IndexType.CONFIGS);
        Archive archive = index.getArchive(ConfigType.OBJECT.getId());
        loader.configureForRevision(archive.getRevision());
        byte[] archiveData = storage.loadArchive(archive);
        ArchiveFiles files = archive.getFiles(archiveData);
        for (FSFile f : files.getFiles()) {
            ObjectDefinition def = loader.load(f.getFileId(), f.getContents());
            this.objects.put(f.getFileId(), def);
        }
    }

    public Collection<ObjectDefinition> getObjects() {
        return Collections.unmodifiableCollection(this.objects.values());
    }

    public ObjectDefinition getObject(int id) {
        return this.objects.get(id);
    }

    public void dump(File out) throws IOException {
        out.mkdirs();
        for (ObjectDefinition def : this.objects.values()) {
            ObjectExporter exporter = new ObjectExporter(def);
            File targ = new File(out, def.getId() + ".json");
            exporter.exportTo(targ);
        }
    }

    public void java(File java) throws IOException {
        java.mkdirs();
        try (IDClass ids = IDClass.create(java, "ObjectID");
             IDClass nulls = IDClass.create(java, "NullObjectID");){
            for (ObjectDefinition def : this.objects.values()) {
                if ("null".equals(def.getName())) {
                    nulls.add(def.getName(), def.getId());
                    continue;
                }
                ids.add(def.getName(), def.getId());
            }
        }
    }
}

