/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.runelite.cache.ConfigType;
import net.runelite.cache.IndexType;
import net.runelite.cache.definitions.NpcDefinition;
import net.runelite.cache.definitions.exporters.NpcExporter;
import net.runelite.cache.definitions.loaders.NpcLoader;
import net.runelite.cache.fs.Archive;
import net.runelite.cache.fs.ArchiveFiles;
import net.runelite.cache.fs.FSFile;
import net.runelite.cache.fs.Index;
import net.runelite.cache.fs.Storage;
import net.runelite.cache.fs.Store;
import net.runelite.cache.util.IDClass;

public class NpcManager {
    private final Store store;
    private final Map<Integer, NpcDefinition> npcs = new HashMap<Integer, NpcDefinition>();

    public NpcManager(Store store) {
        this.store = store;
    }

    public void load() throws IOException {
        NpcLoader loader = new NpcLoader();
        Storage storage = this.store.getStorage();
        Index index = this.store.getIndex(IndexType.CONFIGS);
        Archive archive = index.getArchive(ConfigType.NPC.getId());
        loader.configureForRevision(archive.getRevision());
        byte[] archiveData = storage.loadArchive(archive);
        ArchiveFiles files = archive.getFiles(archiveData);
        for (FSFile f : files.getFiles()) {
            NpcDefinition npc = loader.load(f.getFileId(), f.getContents());
            this.npcs.put(f.getFileId(), npc);
        }
    }

    public Collection<NpcDefinition> getNpcs() {
        return Collections.unmodifiableCollection(this.npcs.values());
    }

    public NpcDefinition get(int npcId) {
        return this.npcs.get(npcId);
    }

    public void dump(File out) throws IOException {
        out.mkdirs();
        for (NpcDefinition def : this.npcs.values()) {
            NpcExporter exporter = new NpcExporter(def);
            File targ = new File(out, def.id + ".json");
            exporter.exportTo(targ);
        }
    }

    public void java(File java) throws IOException {
        java.mkdirs();
        try (IDClass ids = IDClass.create(java, "NpcID");
             IDClass nulls = IDClass.create(java, "NullNpcID");){
            for (NpcDefinition def : this.npcs.values()) {
                if (def.name.equalsIgnoreCase("NULL")) {
                    nulls.add(def.name, def.id);
                    continue;
                }
                ids.add(def.name, def.id);
            }
        }
    }
}

