/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import net.runelite.cache.IndexType;
import net.runelite.cache.definitions.InterfaceDefinition;
import net.runelite.cache.definitions.exporters.InterfaceExporter;
import net.runelite.cache.definitions.loaders.InterfaceLoader;
import net.runelite.cache.fs.Archive;
import net.runelite.cache.fs.ArchiveFiles;
import net.runelite.cache.fs.FSFile;
import net.runelite.cache.fs.Index;
import net.runelite.cache.fs.Storage;
import net.runelite.cache.fs.Store;
import net.runelite.cache.util.Namer;

public class InterfaceManager {
    private final Store store;
    private InterfaceDefinition[][] interfaces;
    private final Namer namer = new Namer();

    public InterfaceManager(Store store) {
        this.store = store;
    }

    public void load() throws IOException {
        InterfaceLoader loader = new InterfaceLoader();
        Storage storage = this.store.getStorage();
        Index index = this.store.getIndex(IndexType.INTERFACES);
        int max = index.getArchives().stream().mapToInt(a -> a.getArchiveId()).max().getAsInt();
        this.interfaces = new InterfaceDefinition[max + 1][];
        for (Archive archive : index.getArchives()) {
            int archiveId = archive.getArchiveId();
            byte[] archiveData = storage.loadArchive(archive);
            ArchiveFiles files = archive.getFiles(archiveData);
            InterfaceDefinition[] ifaces = this.interfaces[archiveId];
            if (ifaces == null) {
                this.interfaces[archiveId] = new InterfaceDefinition[archive.getFileData().length];
                ifaces = this.interfaces[archiveId];
            }
            for (FSFile file : files.getFiles()) {
                InterfaceDefinition iface;
                int fileId = file.getFileId();
                int widgetId = (archiveId << 16) + fileId;
                ifaces[fileId] = iface = loader.load(widgetId, file.getContents());
            }
        }
    }

    public int getNumInterfaceGroups() {
        return this.interfaces.length;
    }

    public int getNumChildren(int groupId) {
        return this.interfaces[groupId].length;
    }

    public InterfaceDefinition[] getIntefaceGroup(int groupId) {
        return this.interfaces[groupId];
    }

    public InterfaceDefinition getInterface(int groupId, int childId) {
        return this.interfaces[groupId][childId];
    }

    public InterfaceDefinition[][] getInterfaces() {
        return this.interfaces;
    }

    public void export(File out) throws IOException {
        out.mkdirs();
        for (InterfaceDefinition[] defs : this.interfaces) {
            if (defs == null) continue;
            for (InterfaceDefinition def : defs) {
                if (def == null) continue;
                InterfaceExporter exporter = new InterfaceExporter(def);
                File folder = new File(out, "" + (def.id >>> 16));
                folder.mkdirs();
                File targ = new File(folder, (def.id & 0xFFFF) + ".json");
                exporter.exportTo(targ);
            }
        }
    }

    public void java(File java) throws IOException {
        System.setProperty("line.separator", "\n");
        java.mkdirs();
        File targ = new File(java, "InterfaceID.java");
        try (PrintWriter fw = new PrintWriter(targ);){
            fw.println("/* This file is automatically generated. Do not edit. */");
            fw.println("package net.runelite.api;");
            fw.println("");
            fw.println("public final class InterfaceID {");
            for (InterfaceDefinition[] defs : this.interfaces) {
                if (defs == null) continue;
                for (InterfaceDefinition def : defs) {
                    String name;
                    if (def == null || def.name == null || def.name.equalsIgnoreCase("NULL") || (name = this.namer.name(def.name, def.id)) == null) continue;
                    fw.println("\tpublic static final int " + name + " = " + def.id + ";");
                }
            }
            fw.println("}");
        }
    }
}

