/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.runelite.cache.ConfigType;
import net.runelite.cache.IndexType;
import net.runelite.cache.definitions.DBTableDefinition;
import net.runelite.cache.definitions.loaders.DBTableLoader;
import net.runelite.cache.fs.Archive;
import net.runelite.cache.fs.ArchiveFiles;
import net.runelite.cache.fs.FSFile;
import net.runelite.cache.fs.Index;
import net.runelite.cache.fs.Storage;
import net.runelite.cache.fs.Store;

public class DBTableManager {
    private final Store store;
    private final Map<Integer, DBTableDefinition> tables = new HashMap<Integer, DBTableDefinition>();

    public DBTableManager(Store store) {
        this.store = store;
    }

    public void load() throws IOException {
        DBTableLoader loader = new DBTableLoader();
        Storage storage = this.store.getStorage();
        Index index = this.store.getIndex(IndexType.CONFIGS);
        Archive archive = index.getArchive(ConfigType.DBTABLE.getId());
        if (archive == null) {
            return;
        }
        byte[] archiveData = storage.loadArchive(archive);
        ArchiveFiles files = archive.getFiles(archiveData);
        for (FSFile f : files.getFiles()) {
            DBTableDefinition table = loader.load(f.getFileId(), f.getContents());
            this.tables.put(f.getFileId(), table);
        }
    }

    public Collection<DBTableDefinition> getTables() {
        return Collections.unmodifiableCollection(this.tables.values());
    }

    public DBTableDefinition get(int tableId) {
        return this.tables.get(tableId);
    }
}

