/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.runelite.cache.ConfigType;
import net.runelite.cache.IndexType;
import net.runelite.cache.definitions.DBRowDefinition;
import net.runelite.cache.definitions.loaders.DBRowLoader;
import net.runelite.cache.fs.Archive;
import net.runelite.cache.fs.ArchiveFiles;
import net.runelite.cache.fs.FSFile;
import net.runelite.cache.fs.Index;
import net.runelite.cache.fs.Storage;
import net.runelite.cache.fs.Store;

public class DBRowManager {
    private final Store store;
    private final Map<Integer, DBRowDefinition> rows = new HashMap<Integer, DBRowDefinition>();

    public DBRowManager(Store store) {
        this.store = store;
    }

    public void load() throws IOException {
        DBRowLoader loader = new DBRowLoader();
        Storage storage = this.store.getStorage();
        Index index = this.store.getIndex(IndexType.CONFIGS);
        Archive archive = index.getArchive(ConfigType.DBROW.getId());
        if (archive == null) {
            return;
        }
        byte[] archiveData = storage.loadArchive(archive);
        ArchiveFiles files = archive.getFiles(archiveData);
        for (FSFile f : files.getFiles()) {
            DBRowDefinition row = loader.load(f.getFileId(), f.getContents());
            this.rows.put(f.getFileId(), row);
        }
    }

    public Collection<DBRowDefinition> getRows() {
        return Collections.unmodifiableCollection(this.rows.values());
    }

    public DBRowDefinition get(int rowId) {
        return this.rows.get(rowId);
    }
}

