/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache.io;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public final class OutputStream
extends java.io.OutputStream {
    private ByteBuffer buffer;

    public OutputStream(int capacity) {
        this.buffer = ByteBuffer.allocate(capacity);
    }

    public OutputStream() {
        this(16);
    }

    public byte[] getArray() {
        assert (this.buffer.hasArray());
        return this.buffer.array();
    }

    private void ensureRemaining(int remaining) {
        while (remaining > this.buffer.remaining()) {
            int newCapacity = this.buffer.capacity() * 2;
            ByteBuffer old = this.buffer;
            old.flip();
            this.buffer = ByteBuffer.allocate(newCapacity);
            this.buffer.put(old);
        }
    }

    public void skip(int length) {
        int pos = this.buffer.position();
        this.buffer.position(pos += length);
    }

    public int getOffset() {
        return this.buffer.position();
    }

    public void setOffset(int offset) {
        this.buffer.position(offset);
    }

    public void writeBytes(byte[] b) {
        this.writeBytes(b, 0, b.length);
    }

    public void writeBytes(byte[] b, int offset, int length) {
        this.ensureRemaining(length);
        this.buffer.put(b, offset, length);
    }

    public void writeByte(int i) {
        this.ensureRemaining(1);
        this.buffer.put((byte)i);
    }

    public void writeBigSmart(int value) {
        Preconditions.checkArgument((value >= 0 ? 1 : 0) != 0);
        if (value >= 32768) {
            this.ensureRemaining(4);
            this.writeInt(Integer.MIN_VALUE | value);
        } else {
            this.ensureRemaining(2);
            this.writeShort(value);
        }
    }

    public void writeShort(int i) {
        this.ensureRemaining(2);
        this.buffer.putShort((short)i);
    }

    public void writeShortSmart(int value) {
        Preconditions.checkArgument((value >= 0 ? 1 : 0) != 0);
        if (value < 128) {
            this.writeByte(value);
        } else {
            this.writeShort(0x8000 | value);
        }
    }

    public void write24BitInt(int i) {
        this.ensureRemaining(3);
        this.buffer.put((byte)(i >>> 16));
        this.buffer.put((byte)(i >>> 8));
        this.buffer.put((byte)(i & 0xFF));
    }

    public void writeInt(int i) {
        this.ensureRemaining(4);
        this.buffer.putInt(i);
    }

    public void writeVarInt(int var1) {
        if ((var1 & 0xFFFFFF80) != 0) {
            if ((var1 & 0xFFFFC000) != 0) {
                if ((var1 & 0xFFE00000) != 0) {
                    if ((var1 & 0xF0000000) != 0) {
                        this.writeByte(var1 >>> 28 | 0x80);
                    }
                    this.writeByte(var1 >>> 21 | 0x80);
                }
                this.writeByte(var1 >>> 14 | 0x80);
            }
            this.writeByte(var1 >>> 7 | 0x80);
        }
        this.writeByte(var1 & 0x7F);
    }

    public void writeLengthFromMark(int var1) {
        this.getArray()[this.getOffset() - var1 - 4] = (byte)(var1 >> 24);
        this.getArray()[this.getOffset() - var1 - 3] = (byte)(var1 >> 16);
        this.getArray()[this.getOffset() - var1 - 2] = (byte)(var1 >> 8);
        this.getArray()[this.getOffset() - var1 - 1] = (byte)var1;
    }

    public void writeString(String str) {
        this.writeBytes(str.getBytes(StandardCharsets.ISO_8859_1));
        this.writeByte(0);
    }

    public byte[] flip() {
        this.buffer.flip();
        byte[] b = new byte[this.buffer.limit()];
        this.buffer.get(b);
        return b;
    }

    @Override
    public void write(int b) throws IOException {
        this.buffer.put((byte)b);
    }
}

