/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.runelite.cache.ConfigType;
import net.runelite.cache.IndexType;
import net.runelite.cache.definitions.StructDefinition;
import net.runelite.cache.definitions.loaders.StructLoader;
import net.runelite.cache.definitions.providers.StructProvider;
import net.runelite.cache.fs.Archive;
import net.runelite.cache.fs.ArchiveFiles;
import net.runelite.cache.fs.FSFile;
import net.runelite.cache.fs.Index;
import net.runelite.cache.fs.Storage;
import net.runelite.cache.fs.Store;

public class StructManager
implements StructProvider {
    private final Store store;
    private final Map<Integer, StructDefinition> structs = new HashMap<Integer, StructDefinition>();

    public StructManager(Store store) {
        this.store = store;
    }

    public void load() throws IOException {
        StructLoader loader = new StructLoader();
        Storage storage = this.store.getStorage();
        Index index = this.store.getIndex(IndexType.CONFIGS);
        Archive archive = index.getArchive(ConfigType.STRUCT.getId());
        byte[] archiveData = storage.loadArchive(archive);
        ArchiveFiles files = archive.getFiles(archiveData);
        for (FSFile f : files.getFiles()) {
            StructDefinition def = loader.load(f.getFileId(), f.getContents());
            this.structs.put(f.getFileId(), def);
        }
    }

    public Map<Integer, StructDefinition> getStructs() {
        return Collections.unmodifiableMap(this.structs);
    }

    public StructDefinition getStruct(int structId) {
        return this.structs.get(structId);
    }

    @Override
    public StructDefinition provide(int structId) {
        return this.getStruct(structId);
    }
}

