/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache.fs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.runelite.cache.fs.Archive;
import net.runelite.cache.index.ArchiveData;
import net.runelite.cache.index.FileData;
import net.runelite.cache.index.IndexData;
import net.runelite.cache.util.Djb2;

public class Index {
    private final int id;
    private int protocol = 6;
    private boolean named = true;
    private boolean sized = false;
    private int revision;
    private int crc;
    private int compression;
    private final List<Archive> archives = new ArrayList<Archive>();

    public Index(int id) {
        this.id = id;
    }

    public List<Archive> getArchives() {
        return Collections.unmodifiableList(this.archives);
    }

    public Archive addArchive(int id) {
        int idx = this.findArchiveIndex(id);
        if (idx >= 0) {
            throw new IllegalArgumentException("archive " + id + " already exists");
        }
        idx = -idx - 1;
        Archive archive = new Archive(this, id);
        this.archives.add(idx, archive);
        return archive;
    }

    public Archive getArchive(int id) {
        int idx = this.findArchiveIndex(id);
        if (idx < 0) {
            return null;
        }
        return this.archives.get(idx);
    }

    private int findArchiveIndex(int id) {
        int low = 0;
        int high = this.archives.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            Archive a = this.archives.get(mid);
            int cmp = Integer.compare(a.getArchiveId(), id);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public boolean removeArchive(Archive archive) {
        return this.archives.remove(archive);
    }

    public Archive findArchiveByName(String name) {
        int hash = Djb2.hash(name);
        for (Archive a : this.archives) {
            if (a.getNameHash() != hash) continue;
            return a;
        }
        return null;
    }

    public IndexData toIndexData() {
        IndexData data = new IndexData();
        data.setProtocol(this.protocol);
        data.setRevision(this.revision);
        data.setNamed(this.named);
        data.setSized(this.sized);
        ArchiveData[] archiveDatas = new ArchiveData[this.archives.size()];
        data.setArchives(archiveDatas);
        int idx = 0;
        for (Archive archive : this.archives) {
            int n = idx++;
            ArchiveData archiveData = new ArchiveData();
            archiveDatas[n] = archiveData;
            ArchiveData ad = archiveData;
            ad.setId(archive.getArchiveId());
            ad.setNameHash(archive.getNameHash());
            ad.setCrc(archive.getCrc());
            ad.setRevision(archive.getRevision());
            ad.setCompressedSize(archive.getCompressedSize());
            ad.setDecompressedSize(archive.getDecompressedSize());
            FileData[] files = archive.getFileData();
            ad.setFiles(files);
        }
        return data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Index)) {
            return false;
        }
        Index other = (Index)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getRevision() != other.getRevision()) {
            return false;
        }
        List<Archive> this$archives = this.getArchives();
        List<Archive> other$archives = other.getArchives();
        return !(this$archives == null ? other$archives != null : !((Object)this$archives).equals(other$archives));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Index;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        result = result * 59 + this.getRevision();
        List<Archive> $archives = this.getArchives();
        result = result * 59 + ($archives == null ? 43 : ((Object)$archives).hashCode());
        return result;
    }

    public int getId() {
        return this.id;
    }

    public void setProtocol(int protocol) {
        this.protocol = protocol;
    }

    public int getProtocol() {
        return this.protocol;
    }

    public void setNamed(boolean named) {
        this.named = named;
    }

    public boolean isNamed() {
        return this.named;
    }

    public void setSized(boolean sized) {
        this.sized = sized;
    }

    public boolean isSized() {
        return this.sized;
    }

    public void setRevision(int revision) {
        this.revision = revision;
    }

    public int getRevision() {
        return this.revision;
    }

    public void setCrc(int crc) {
        this.crc = crc;
    }

    public int getCrc() {
        return this.crc;
    }

    public void setCompression(int compression) {
        this.compression = compression;
    }

    public int getCompression() {
        return this.compression;
    }
}

