/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache.util;

import java.util.HashMap;
import java.util.Map;

public enum ScriptVarType {
    INTEGER(0, 'i', "integer"),
    BOOLEAN(1, '1', "boolean"),
    SEQ(6, 'A', "seq"),
    COLOUR(7, 'C', "colour"),
    LOC_SHAPE(8, 'H', "locshape"),
    COMPONENT(9, 'I', "component"),
    IDKIT(10, 'K', "idkit"),
    MIDI(11, 'M', "midi"),
    NAMEDOBJ(13, 'O', "namedobj"),
    SYNTH(14, 'P', "synth"),
    STAT(17, 'S', "stat"),
    COORDGRID(22, 'c', "coordgrid"),
    GRAPHIC(23, 'd', "graphic"),
    FONTMETRICS(25, 'f', "fontmetrics"),
    ENUM(26, 'g', "enum"),
    JINGLE(28, 'j', "jingle"),
    LOC(30, 'l', "loc"),
    MODEL(31, 'm', "model"),
    NPC(32, 'n', "npc"),
    OBJ(33, 'o', "obj"),
    STRING(36, 's', "string"),
    SPOTANIM(37, 't', "spotanim"),
    INV(39, 'v', "inv"),
    TEXTURE(40, 'x', "texture"),
    CATEGORY(41, 'y', "category"),
    CHAR(42, 'z', "char"),
    MAPSCENEICON(55, '\u00a3', "mapsceneicon"),
    MAPELEMENT(59, '\u00b5', "mapelement"),
    HITMARK(62, '\u00d7', "hitmark"),
    STRUCT(73, 'J', "struct"),
    DBROW(74, '\u00d0', "dbrow"),
    VARP(209, '7', "varp");

    private static final Map<Integer, ScriptVarType> idToTypeMap;
    private static final Map<Character, ScriptVarType> keyToTypeMap;
    private final int id;
    private final char keyChar;
    private final String fullName;

    public static ScriptVarType forId(int id) {
        return idToTypeMap.get(id);
    }

    public static ScriptVarType forCharKey(char key) {
        return keyToTypeMap.get(Character.valueOf(key));
    }

    private ScriptVarType(int id, char keyChar, String fullName) {
        this.id = id;
        this.keyChar = keyChar;
        this.fullName = fullName;
    }

    public int getId() {
        return this.id;
    }

    public char getKeyChar() {
        return this.keyChar;
    }

    public String getFullName() {
        return this.fullName;
    }

    static {
        idToTypeMap = new HashMap<Integer, ScriptVarType>();
        keyToTypeMap = new HashMap<Character, ScriptVarType>();
        for (ScriptVarType type : ScriptVarType.values()) {
            if (type.id != -1) {
                idToTypeMap.put(type.id, type);
            }
            keyToTypeMap.put(Character.valueOf(type.keyChar), type);
        }
    }
}

