/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache.definitions.loaders;

import java.util.HashMap;
import net.runelite.cache.definitions.ObjectDefinition;
import net.runelite.cache.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectLoader {
    private static final Logger log = LoggerFactory.getLogger(ObjectLoader.class);
    public static final int REV_220_OBJ_ARCHIVE_REV = 1673;
    private boolean rev220SoundData = true;

    public ObjectLoader configureForRevision(int rev) {
        this.rev220SoundData = rev >= 1673;
        return this;
    }

    public ObjectDefinition load(int id, byte[] b) {
        int opcode;
        ObjectDefinition def = new ObjectDefinition();
        InputStream is = new InputStream(b);
        def.setId(id);
        while ((opcode = is.readUnsignedByte()) != 0) {
            this.processOp(opcode, def, is);
        }
        this.post(def);
        return def;
    }

    private void processOp(int opcode, ObjectDefinition def, InputStream is) {
        if (opcode == 1) {
            int length = is.readUnsignedByte();
            if (length > 0) {
                int[] objectTypes = new int[length];
                int[] objectModels = new int[length];
                for (int index = 0; index < length; ++index) {
                    objectModels[index] = is.readUnsignedShort();
                    objectTypes[index] = is.readUnsignedByte();
                }
                def.setObjectTypes(objectTypes);
                def.setObjectModels(objectModels);
            }
        } else if (opcode == 2) {
            def.setName(is.readString());
        } else if (opcode == 5) {
            int length = is.readUnsignedByte();
            if (length > 0) {
                def.setObjectTypes(null);
                int[] objectModels = new int[length];
                for (int index = 0; index < length; ++index) {
                    objectModels[index] = is.readUnsignedShort();
                }
                def.setObjectModels(objectModels);
            }
        } else if (opcode == 14) {
            def.setSizeX(is.readUnsignedByte());
        } else if (opcode == 15) {
            def.setSizeY(is.readUnsignedByte());
        } else if (opcode == 17) {
            def.setInteractType(0);
            def.setBlocksProjectile(false);
        } else if (opcode == 18) {
            def.setBlocksProjectile(false);
        } else if (opcode == 19) {
            def.setWallOrDoor(is.readUnsignedByte());
        } else if (opcode == 21) {
            def.setContouredGround(0);
        } else if (opcode == 22) {
            def.setMergeNormals(true);
        } else if (opcode == 23) {
            def.setModelClipped(true);
        } else if (opcode == 24) {
            def.setAnimationID(is.readUnsignedShort());
            if (def.getAnimationID() == 65535) {
                def.setAnimationID(-1);
            }
        } else if (opcode == 27) {
            def.setInteractType(1);
        } else if (opcode == 28) {
            def.setDecorDisplacement(is.readUnsignedByte());
        } else if (opcode == 29) {
            def.setAmbient(is.readByte());
        } else if (opcode == 39) {
            def.setContrast(is.readByte() * 25);
        } else if (opcode >= 30 && opcode < 35) {
            String[] actions = def.getActions();
            actions[opcode - 30] = is.readString();
            if (actions[opcode - 30].equalsIgnoreCase("Hidden")) {
                actions[opcode - 30] = null;
            }
        } else if (opcode == 40) {
            int length = is.readUnsignedByte();
            short[] recolorToFind = new short[length];
            short[] recolorToReplace = new short[length];
            for (int index = 0; index < length; ++index) {
                recolorToFind[index] = is.readShort();
                recolorToReplace[index] = is.readShort();
            }
            def.setRecolorToFind(recolorToFind);
            def.setRecolorToReplace(recolorToReplace);
        } else if (opcode == 41) {
            int length = is.readUnsignedByte();
            short[] retextureToFind = new short[length];
            short[] textureToReplace = new short[length];
            for (int index = 0; index < length; ++index) {
                retextureToFind[index] = is.readShort();
                textureToReplace[index] = is.readShort();
            }
            def.setRetextureToFind(retextureToFind);
            def.setTextureToReplace(textureToReplace);
        } else if (opcode == 61) {
            def.setCategory(is.readUnsignedShort());
        } else if (opcode == 62) {
            def.setRotated(true);
        } else if (opcode == 64) {
            def.setShadow(false);
        } else if (opcode == 65) {
            def.setModelSizeX(is.readUnsignedShort());
        } else if (opcode == 66) {
            def.setModelSizeHeight(is.readUnsignedShort());
        } else if (opcode == 67) {
            def.setModelSizeY(is.readUnsignedShort());
        } else if (opcode == 68) {
            def.setMapSceneID(is.readUnsignedShort());
        } else if (opcode == 69) {
            def.setBlockingMask(is.readByte());
        } else if (opcode == 70) {
            def.setOffsetX(is.readUnsignedShort());
        } else if (opcode == 71) {
            def.setOffsetHeight(is.readUnsignedShort());
        } else if (opcode == 72) {
            def.setOffsetY(is.readUnsignedShort());
        } else if (opcode == 73) {
            def.setObstructsGround(true);
        } else if (opcode == 74) {
            def.setHollow(true);
        } else if (opcode == 75) {
            def.setSupportsItems(is.readUnsignedByte());
        } else if (opcode == 77) {
            int varpID = is.readUnsignedShort();
            if (varpID == 65535) {
                varpID = -1;
            }
            def.setVarbitID(varpID);
            int configId = is.readUnsignedShort();
            if (configId == 65535) {
                configId = -1;
            }
            def.setVarpID(configId);
            int length = is.readUnsignedByte();
            int[] configChangeDest = new int[length + 2];
            for (int index = 0; index <= length; ++index) {
                configChangeDest[index] = is.readUnsignedShort();
                if (65535 != configChangeDest[index]) continue;
                configChangeDest[index] = -1;
            }
            configChangeDest[length + 1] = -1;
            def.setConfigChangeDest(configChangeDest);
        } else if (opcode == 78) {
            def.setAmbientSoundId(is.readUnsignedShort());
            def.setAmbientSoundDistance(is.readUnsignedByte());
            if (this.rev220SoundData) {
                def.setAmbientSoundRetain(is.readUnsignedByte());
            }
        } else if (opcode == 79) {
            def.setAmbientSoundChangeTicksMin(is.readUnsignedShort());
            def.setAmbientSoundChangeTicksMax(is.readUnsignedShort());
            def.setAmbientSoundDistance(is.readUnsignedByte());
            if (this.rev220SoundData) {
                def.setAmbientSoundRetain(is.readUnsignedByte());
            }
            int length = is.readUnsignedByte();
            int[] ambientSoundIds = new int[length];
            for (int index = 0; index < length; ++index) {
                ambientSoundIds[index] = is.readUnsignedShort();
            }
            def.setAmbientSoundIds(ambientSoundIds);
        } else if (opcode == 81) {
            def.setContouredGround(is.readUnsignedByte() * 256);
        } else if (opcode == 82) {
            def.setMapAreaId(is.readUnsignedShort());
        } else if (opcode == 89) {
            def.setRandomizeAnimStart(true);
        } else if (opcode == 90) {
            def.setDeferAnimChange(true);
        } else if (opcode == 91) {
            def.setSoundDistanceFadeCurve(is.readUnsignedByte());
        } else if (opcode == 92) {
            int varpID = is.readUnsignedShort();
            if (varpID == 65535) {
                varpID = -1;
            }
            def.setVarbitID(varpID);
            int configId = is.readUnsignedShort();
            if (configId == 65535) {
                configId = -1;
            }
            def.setVarpID(configId);
            int var = is.readUnsignedShort();
            if (var == 65535) {
                var = -1;
            }
            int length = is.readUnsignedByte();
            int[] configChangeDest = new int[length + 2];
            for (int index = 0; index <= length; ++index) {
                configChangeDest[index] = is.readUnsignedShort();
                if (65535 != configChangeDest[index]) continue;
                configChangeDest[index] = -1;
            }
            configChangeDest[length + 1] = var;
            def.setConfigChangeDest(configChangeDest);
        } else if (opcode == 93) {
            def.setSoundFadeInCurve(is.readUnsignedByte());
            def.setSoundFadeInDuration(is.readUnsignedShort());
            def.setSoundFadeOutCurve(is.readUnsignedByte());
            def.setSoundFadeOutDuration(is.readUnsignedShort());
        } else if (opcode == 94) {
            def.setUnknown1(true);
        } else if (opcode == 249) {
            int length = is.readUnsignedByte();
            HashMap<Integer, Object> params = new HashMap<Integer, Object>(length);
            for (int i = 0; i < length; ++i) {
                boolean isString = is.readUnsignedByte() == 1;
                int key = is.read24BitInt();
                Object value = isString ? is.readString() : Integer.valueOf(is.readInt());
                params.put(key, value);
            }
            def.setParams(params);
        } else {
            log.warn("Unrecognized opcode {}", (Object)opcode);
        }
    }

    private void post(ObjectDefinition def) {
        if (def.getWallOrDoor() == -1) {
            def.setWallOrDoor(0);
            if (def.getObjectModels() != null && (def.getObjectTypes() == null || def.getObjectTypes()[0] == 10)) {
                def.setWallOrDoor(1);
            }
            for (int var1 = 0; var1 < 5; ++var1) {
                if (def.getActions()[var1] == null) continue;
                def.setWallOrDoor(1);
            }
        }
        if (def.getSupportsItems() == -1) {
            def.setSupportsItems(def.getInteractType() != 0 ? 1 : 0);
        }
    }

    public boolean isRev220SoundData() {
        return this.rev220SoundData;
    }

    public ObjectLoader setRev220SoundData(boolean rev220SoundData) {
        this.rev220SoundData = rev220SoundData;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObjectLoader)) {
            return false;
        }
        ObjectLoader other = (ObjectLoader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.isRev220SoundData() == other.isRev220SoundData();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ObjectLoader;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isRev220SoundData() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "ObjectLoader(rev220SoundData=" + this.isRev220SoundData() + ")";
    }
}

