/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache.fs;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import java.io.IOException;
import net.runelite.cache.io.InputStream;
import net.runelite.cache.io.OutputStream;
import net.runelite.cache.util.BZip2;
import net.runelite.cache.util.Crc32;
import net.runelite.cache.util.GZip;
import net.runelite.cache.util.Xtea;

public class Container {
    public byte[] data;
    public int compression;
    public int revision;
    public int crc;

    public Container(int compression, int revision) {
        this.compression = compression;
        this.revision = revision;
    }

    public void compress(byte[] data, int[] keys) throws IOException {
        int length;
        byte[] compressedData;
        OutputStream stream = new OutputStream();
        switch (this.compression) {
            case 0: {
                compressedData = data;
                length = compressedData.length;
                break;
            }
            case 1: {
                compressedData = Bytes.concat((byte[][])new byte[][]{Ints.toByteArray((int)data.length), BZip2.compress(data)});
                length = compressedData.length - 4;
                break;
            }
            case 2: {
                compressedData = Bytes.concat((byte[][])new byte[][]{Ints.toByteArray((int)data.length), GZip.compress(data)});
                length = compressedData.length - 4;
                break;
            }
            default: {
                throw new RuntimeException("Unknown compression type");
            }
        }
        compressedData = Container.encrypt(compressedData, compressedData.length, keys);
        stream.writeByte(this.compression);
        stream.writeInt(length);
        stream.writeBytes(compressedData);
        if (this.revision != -1) {
            stream.writeShort(this.revision);
        }
        this.data = stream.flip();
        Crc32 crc32 = new Crc32();
        crc32.update(this.data, 0, this.data.length - (this.revision != -1 ? 2 : 0));
        this.crc = crc32.getHash();
    }

    public static Container decompress(byte[] b, int[] keys) throws IOException {
        byte[] data;
        InputStream stream = new InputStream(b);
        int compression = stream.readUnsignedByte();
        int compressedLength = stream.readInt();
        if (compressedLength < 0) {
            throw new RuntimeException("Invalid data");
        }
        Crc32 crc32 = new Crc32();
        crc32.update(b, 0, 5);
        int revision = -1;
        switch (compression) {
            case 0: {
                byte[] encryptedData = new byte[compressedLength];
                stream.readBytes(encryptedData, 0, compressedLength);
                crc32.update(encryptedData, 0, compressedLength);
                byte[] decryptedData = Container.decrypt(encryptedData, encryptedData.length, keys);
                if (stream.remaining() >= 2) {
                    revision = stream.readUnsignedShort();
                    assert (revision != -1);
                }
                data = decryptedData;
                break;
            }
            case 1: {
                byte[] encryptedData = new byte[compressedLength + 4];
                stream.readBytes(encryptedData);
                crc32.update(encryptedData, 0, encryptedData.length);
                byte[] decryptedData = Container.decrypt(encryptedData, encryptedData.length, keys);
                if (stream.remaining() >= 2) {
                    revision = stream.readUnsignedShort();
                    assert (revision != -1);
                }
                stream = new InputStream(decryptedData);
                int decompressedLength = stream.readInt();
                data = BZip2.decompress(stream.getRemaining(), compressedLength);
                assert (data.length == decompressedLength);
                break;
            }
            case 2: {
                byte[] encryptedData = new byte[compressedLength + 4];
                stream.readBytes(encryptedData);
                crc32.update(encryptedData, 0, encryptedData.length);
                byte[] decryptedData = Container.decrypt(encryptedData, encryptedData.length, keys);
                if (stream.remaining() >= 2) {
                    revision = stream.readUnsignedShort();
                    assert (revision != -1);
                }
                stream = new InputStream(decryptedData);
                int decompressedLength = stream.readInt();
                data = GZip.decompress(stream.getRemaining(), compressedLength);
                assert (data.length == decompressedLength);
                break;
            }
            default: {
                throw new RuntimeException("Unknown decompression type");
            }
        }
        Container container = new Container(compression, revision);
        container.data = data;
        container.crc = crc32.getHash();
        return container;
    }

    private static byte[] decrypt(byte[] data, int length, int[] keys) {
        if (keys == null) {
            return data;
        }
        Xtea xtea = new Xtea(keys);
        return xtea.decrypt(data, length);
    }

    private static byte[] encrypt(byte[] data, int length, int[] keys) {
        if (keys == null) {
            return data;
        }
        Xtea xtea = new Xtea(keys);
        return xtea.encrypt(data, length);
    }
}

