/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.cache;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.runelite.cache.IndexType;
import net.runelite.cache.definitions.SpriteDefinition;
import net.runelite.cache.definitions.exporters.SpriteExporter;
import net.runelite.cache.definitions.loaders.SpriteLoader;
import net.runelite.cache.definitions.providers.SpriteProvider;
import net.runelite.cache.fs.Archive;
import net.runelite.cache.fs.Index;
import net.runelite.cache.fs.Storage;
import net.runelite.cache.fs.Store;
import net.runelite.cache.util.Djb2;

public class SpriteManager
implements SpriteProvider {
    private final Store store;
    private final Multimap<Integer, SpriteDefinition> sprites = LinkedListMultimap.create();
    private final Map<Integer, Integer> spriteIdsByArchiveNameHash = new HashMap<Integer, Integer>();

    public SpriteManager(Store store) {
        this.store = store;
    }

    public void load() throws IOException {
        Storage storage = this.store.getStorage();
        Index index = this.store.getIndex(IndexType.SPRITES);
        for (Archive a : index.getArchives()) {
            SpriteDefinition[] defs;
            byte[] contents = a.decompress(storage.loadArchive(a));
            SpriteLoader loader = new SpriteLoader();
            for (SpriteDefinition sprite : defs = loader.load(a.getArchiveId(), contents)) {
                this.sprites.put((Object)sprite.getId(), (Object)sprite);
                this.spriteIdsByArchiveNameHash.put(a.getNameHash(), sprite.getId());
            }
        }
    }

    public Collection<SpriteDefinition> getSprites() {
        return Collections.unmodifiableCollection(this.sprites.values());
    }

    public SpriteDefinition findSprite(int spriteId, int frameId) {
        for (SpriteDefinition sprite : this.sprites.get((Object)spriteId)) {
            if (sprite.getFrame() != frameId) continue;
            return sprite;
        }
        return null;
    }

    public BufferedImage getSpriteImage(SpriteDefinition sprite) {
        BufferedImage image = new BufferedImage(sprite.getWidth(), sprite.getHeight(), 2);
        image.setRGB(0, 0, sprite.getWidth(), sprite.getHeight(), sprite.getPixels(), 0, sprite.getWidth());
        return image;
    }

    public SpriteDefinition findSpriteByArchiveName(String name, int frameId) {
        int nameHash = Djb2.hash(name);
        Integer spriteId = this.spriteIdsByArchiveNameHash.get(nameHash);
        if (spriteId != null) {
            return this.findSprite(spriteId, frameId);
        }
        return null;
    }

    public void export(File outDir) throws IOException {
        for (SpriteDefinition sprite : this.sprites.values()) {
            if (sprite.getHeight() <= 0 || sprite.getWidth() <= 0) continue;
            SpriteExporter exporter = new SpriteExporter(sprite);
            File png = new File(outDir, sprite.getId() + "-" + sprite.getFrame() + ".png");
            exporter.exportTo(png);
        }
    }

    @Override
    public SpriteDefinition provide(int spriteId, int frameId) {
        return this.findSprite(spriteId, frameId);
    }
}

